/*
 * Decompiled with CFR 0.152.
 */
package minisu.dropwizard.interpolation;

import io.dropwizard.configuration.ConfigurationSourceProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import org.apache.commons.lang3.text.StrSubstitutor;

public class SubstitutingSourceProvider
implements ConfigurationSourceProvider {
    private final ConfigurationSourceProvider baseProvider;
    private final StrSubstitutor strSubstitutor;

    public SubstitutingSourceProvider(ConfigurationSourceProvider baseProvider, StrSubstitutor strSubstitutor) {
        this.baseProvider = baseProvider;
        this.strSubstitutor = strSubstitutor;
    }

    public InputStream open(String path) throws IOException {
        String config = SubstitutingSourceProvider.convertStreamToString(this.baseProvider.open(path));
        StrSubstitutor environmentVariableSubstitutor = this.strSubstitutor;
        String substitutedConfig = environmentVariableSubstitutor.replace(config);
        return new ByteArrayInputStream(substitutedConfig.getBytes());
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

