/*
 * Decompiled with CFR 0.152.
 */
package com.shash.dropwizard.interpolation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.Yaml;
import com.shash.dropwizard.interpolation.S3EnvironmentVariableLookup;
import com.shash.dropwizard.interpolation.S3InterpolationConfig;
import com.shash.dropwizard.interpolation.S3VariableResolver;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;

public class VariableProvider
implements ConfigurationSourceProvider {
    private final ConfigurationSourceProvider baseProvider;
    private final S3VariableResolver s3VariableResolver;
    private final ObjectMapper mapper;
    private final Yaml yaml;

    public VariableProvider(ConfigurationSourceProvider baseProvider, ObjectMapper mapper, Yaml yaml) {
        this.mapper = mapper;
        this.yaml = yaml;
        this.baseProvider = baseProvider;
        this.s3VariableResolver = new S3VariableResolver(this.mapper, this.yaml);
    }

    public InputStream open(String path) throws IOException {
        Map dropwizardConf = (Map)this.yaml.loadAs(this.baseProvider.open(path), Map.class);
        S3InterpolationConfig s3Config = this.s3VariableResolver.parseS3Config(dropwizardConf);
        if (s3Config == null) {
            return new ByteArrayInputStream(this.yaml.dump((Object)dropwizardConf).getBytes());
        }
        Map<String, String> resolvedS3Variables = this.s3VariableResolver.resolve(s3Config);
        StrSubstitutor strSubstitutor = new StrSubstitutor((StrLookup)new S3EnvironmentVariableLookup(resolvedS3Variables, s3Config.getS3VarPrefix()));
        String resolvedConfigStr = strSubstitutor.replace(this.mapper.writeValueAsString((Object)dropwizardConf));
        String resolvedConfig = this.yaml.dump(this.yaml.loadAs(resolvedConfigStr, Map.class));
        return new ByteArrayInputStream(resolvedConfig.getBytes());
    }
}

