/*
 * Decompiled with CFR 0.152.
 */
package com.shash.dropwizard.interpolation;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.Yaml;
import com.shash.dropwizard.interpolation.S3InterpolationConfig;
import com.shash.dropwizard.interpolation.S3VarInterpolationException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3VariableResolver {
    private static final Logger log = LoggerFactory.getLogger(S3VariableResolver.class);
    private static final String S3_VAR_INTERPOLATION = "s3InterpolationConf";
    private static final String S3_DEFAULT_REGION = "AP_SOUTHEAST_1";
    private static final String DOWNLOAD_FILE_NAME = "s3variables.tmp";
    private final Yaml yaml;
    private final AmazonS3 client = new AmazonS3Client();
    private final ObjectMapper mapper;

    public S3VariableResolver(ObjectMapper mapper, Yaml yaml) {
        this.mapper = mapper;
        this.yaml = yaml;
    }

    public Map<String, String> resolve(S3InterpolationConfig s3InterpolationConf) {
        Map<String, String> resolvedVars;
        this.client.setRegion(s3InterpolationConf.getRegion() == null ? Region.getRegion((Regions)Regions.valueOf((String)S3_DEFAULT_REGION)) : Region.getRegion((Regions)Regions.valueOf((String)s3InterpolationConf.getRegion())));
        File downloadedFile = null;
        InputStream downloadStream = null;
        try {
            downloadStream = this.download(s3InterpolationConf.getBucket(), s3InterpolationConf.getKey(), s3InterpolationConf.getVersion());
            downloadedFile = this.save(downloadStream);
            resolvedVars = this.getVariableValues(downloadedFile);
        }
        catch (Exception e) {
            log.error("Exception - {}", (Object)e.getMessage(), (Object)e);
            throw new S3VarInterpolationException("Exception occurred", e);
        }
        finally {
            if (downloadedFile != null) {
                downloadedFile.delete();
            }
            if (downloadStream != null) {
                IOUtils.closeQuietly((Closeable)downloadStream, null);
            }
        }
        return resolvedVars;
    }

    public S3InterpolationConfig parseS3Config(Map<String, Object> dropwizardConfig) {
        try {
            return (S3InterpolationConfig)this.mapper.convertValue(dropwizardConfig.get(S3_VAR_INTERPOLATION), S3InterpolationConfig.class);
        }
        catch (Exception e) {
            log.error("Encountered exception while parsing s3 config - {}", (Object)e.getMessage(), (Object)e);
            throw new S3VarInterpolationException("Unable to parse s3 configuration.", e);
        }
    }

    private Map<String, String> getVariableValues(File downloadFile) throws Exception {
        return (Map)this.yaml.loadAs((InputStream)new FileInputStream(downloadFile), Map.class);
    }

    private InputStream download(String bucket, String key, String version) {
        S3Object s3Object;
        log.info("Fetching object from S3 bucket - {}, key - {}", (Object)bucket, (Object)key);
        try {
            s3Object = this.client.getObject(new GetObjectRequest(bucket, key, version));
        }
        catch (Exception e) {
            log.error("S3 Download operation failed. {}", (Object)e.getMessage(), (Object)e);
            throw new S3VarInterpolationException("S3 downloadAndSave operation failed.", e);
        }
        log.debug("S3 Downloaded object: {}", (Object)s3Object.toString());
        return s3Object.getObjectContent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File save(InputStream inputStream) {
        Path path = null;
        FileOutputStream out = null;
        try {
            path = Files.createFile(Paths.get(DOWNLOAD_FILE_NAME, ""), new FileAttribute[0]);
            out = new FileOutputStream(path.toFile());
            if (inputStream == null) return path.toFile();
            if (out == null) return path.toFile();
        }
        catch (IOException e) {
            try {
                log.error("Encountered exception. ", (Throwable)e);
                throw new S3VarInterpolationException("Encountered exception.", e);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                if (out == null) throw throwable;
                try {
                    IOUtils.copy((InputStream)inputStream, out);
                    IOUtils.closeQuietly(out, null);
                    throw throwable;
                }
                catch (IOException ignore) {
                    log.error("Exception - ", (Throwable)ignore);
                }
                throw throwable;
            }
        }
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            IOUtils.closeQuietly((Closeable)out, null);
            return path.toFile();
        }
        catch (IOException ignore) {
            log.error("Exception - ", (Throwable)ignore);
            return path.toFile();
        }
    }
}

