/*
 * Decompiled with CFR 0.152.
 */
package com.shash.dropwizard.interpolation;

import com.google.common.base.Strings;
import com.shash.dropwizard.interpolation.S3VarInterpolationException;
import java.util.Map;
import org.apache.commons.lang3.text.StrLookup;

public class S3EnvironmentVariableLookup
extends StrLookup {
    private static final String DEFAULT_S3_PREFIX = "S3_INTERPOLATION";
    private final Map<String, String> s3Variables;
    private final String s3VarPrefix;

    public S3EnvironmentVariableLookup(Map<String, String> s3Variables, String s3VarPrefix) {
        this.s3Variables = s3Variables;
        this.s3VarPrefix = Strings.isNullOrEmpty((String)s3VarPrefix) ? DEFAULT_S3_PREFIX : s3VarPrefix;
    }

    public String lookup(String key) {
        if (key != null && key.toUpperCase().trim().startsWith(this.s3VarPrefix)) {
            if (this.s3Variables == null) {
                throw new S3VarInterpolationException("The s3 variable '" + key + "' is not defined. " + "'${" + key + "}'." + " Is this available on s3 file or you missed to provide the config for s3?");
            }
            String value = this.s3Variables.get(key);
            if (value == null) {
                throw new S3VarInterpolationException("The s3 variable '" + key + "' is not defined in s3 file; could not substitute the expression '${" + key + "}'.");
            }
            return value.trim();
        }
        return null;
    }
}

