(ns csv-export-bolt.storage.core
  (:require [csv-export-bolt.storage.s3 :as s3]))


(defmulti store
  "Polymorphic function for dispatching to a backend handler that should return
   the result of the operation and retry until successful or throw an error."
  (fn [backend & args] (keyword backend)))

(defmethod store :default
  [backend conf & [args]]
  (throw (Exception. (str "Backend not found for " backend))))

(defmethod store :s3
  [_ conf location file-path]
  (s3/store-file conf location file-path))
