/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.hbase.ds;

import com.sematext.hbase.ds.AbstractRowKeyDistributor;
import com.sematext.hbase.ds.Parametrizable;
import java.util.Arrays;
import org.apache.hadoop.hbase.util.Bytes;

public class RowKeyDistributorByHashPrefix
extends AbstractRowKeyDistributor {
    private static final String DELIM = "--";
    private Hasher hasher;

    public RowKeyDistributorByHashPrefix() {
    }

    public RowKeyDistributorByHashPrefix(Hasher hasher) {
        this.hasher = hasher;
    }

    @Override
    public byte[] getDistributedKey(byte[] originalKey) {
        return Bytes.add((byte[])this.hasher.getHashPrefix(originalKey), (byte[])originalKey);
    }

    @Override
    public byte[] getOriginalKey(byte[] adjustedKey) {
        int prefixLength = this.hasher.getPrefixLength(adjustedKey);
        if (prefixLength > 0) {
            return Bytes.tail((byte[])adjustedKey, (int)(adjustedKey.length - prefixLength));
        }
        return adjustedKey;
    }

    @Override
    public byte[][] getAllDistributedKeys(byte[] originalKey) {
        byte[][] allPrefixes = this.hasher.getAllPossiblePrefixes();
        byte[][] keys = new byte[allPrefixes.length][];
        for (int i = 0; i < allPrefixes.length; ++i) {
            keys[i] = Bytes.add((byte[])allPrefixes[i], (byte[])originalKey);
        }
        return keys;
    }

    @Override
    public String getParamsToStore() {
        String hasherParamsToStore = this.hasher.getParamsToStore();
        return this.hasher.getClass().getName() + DELIM + (hasherParamsToStore == null ? "" : hasherParamsToStore);
    }

    @Override
    public void init(String params) {
        String[] parts = params.split(DELIM, 2);
        try {
            this.hasher = (Hasher)Class.forName(parts[0]).newInstance();
            this.hasher.init(parts[1]);
        }
        catch (Exception e) {
            throw new RuntimeException("RoKeyDistributor initialization failed", e);
        }
    }

    public static class OneByteSimpleHash
    implements Hasher {
        private int mod;
        private static final byte[][] PREFIXES = new byte[256][];

        public OneByteSimpleHash() {
        }

        public OneByteSimpleHash(int maxBuckets) {
            if (maxBuckets < 1 || maxBuckets > 256) {
                throw new IllegalArgumentException("maxBuckets should be in 1..256 range");
            }
            this.mod = maxBuckets;
        }

        @Override
        public byte[] getHashPrefix(byte[] originalKey) {
            long hash = Math.abs(OneByteSimpleHash.hashBytes(originalKey));
            return new byte[]{(byte)(hash % (long)this.mod)};
        }

        @Override
        public byte[][] getAllPossiblePrefixes() {
            return (byte[][])Arrays.copyOfRange(PREFIXES, 0, this.mod);
        }

        @Override
        public int getPrefixLength(byte[] adjustedKey) {
            return 1;
        }

        @Override
        public String getParamsToStore() {
            return String.valueOf(this.mod);
        }

        @Override
        public void init(String storedParams) {
            this.mod = Integer.valueOf(storedParams);
        }

        private static int hashBytes(byte[] bytes) {
            int hash = 1;
            for (int i = 0; i < bytes.length; ++i) {
                hash = 31 * hash + bytes[i];
            }
            return hash;
        }

        static {
            for (int i = 0; i < 256; ++i) {
                OneByteSimpleHash.PREFIXES[i] = new byte[]{(byte)i};
            }
        }
    }

    public static interface Hasher
    extends Parametrizable {
        public byte[] getHashPrefix(byte[] var1);

        public byte[][] getAllPossiblePrefixes();

        public int getPrefixLength(byte[] var1);
    }
}

