/*
 * Decompiled with CFR 0.152.
 */
package com.sematext.hbase.ds;

import com.sematext.hbase.ds.AbstractRowKeyDistributor;
import org.apache.hadoop.hbase.util.Bytes;

public class RowKeyDistributorByOneBytePrefix
extends AbstractRowKeyDistributor {
    private static final byte[][] PREFIXES = new byte[127][];
    private byte maxPrefix;
    private byte nextPrefix;

    public RowKeyDistributorByOneBytePrefix() {
    }

    public RowKeyDistributorByOneBytePrefix(byte bucketsCount) {
        this.maxPrefix = bucketsCount;
        this.nextPrefix = 0;
    }

    @Override
    public byte[] getDistributedKey(byte[] originalKey) {
        byte by = this.nextPrefix;
        this.nextPrefix = (byte)(by + 1);
        byte prefix = (byte)Math.abs(by % this.maxPrefix);
        return Bytes.add((byte[])PREFIXES[prefix], (byte[])originalKey);
    }

    @Override
    public byte[] getOriginalKey(byte[] adjustedKey) {
        return Bytes.tail((byte[])adjustedKey, (int)(adjustedKey.length - 1));
    }

    @Override
    public byte[][] getAllDistributedKeys(byte[] originalKey) {
        return RowKeyDistributorByOneBytePrefix.getAllDistributedKeys(originalKey, this.maxPrefix);
    }

    private static byte[][] getAllDistributedKeys(byte[] originalKey, byte maxPrefix) {
        byte[][] keys = new byte[maxPrefix][];
        for (byte i = 0; i < maxPrefix; i = (byte)(i + 1)) {
            keys[i] = Bytes.add((byte[])PREFIXES[i], (byte[])originalKey);
        }
        return keys;
    }

    @Override
    public String getParamsToStore() {
        return String.valueOf(this.maxPrefix);
    }

    @Override
    public void init(String params) {
        this.maxPrefix = Byte.parseByte(params);
    }

    static {
        for (byte i = 0; i < 127; i = (byte)((byte)(i + 1))) {
            RowKeyDistributorByOneBytePrefix.PREFIXES[i] = new byte[]{i};
        }
    }
}

