/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.LongUtils;
import com.martiansoftware.nailgun.NGContext;
import com.martiansoftware.nailgun.NGInputStream;
import com.martiansoftware.nailgun.NGOutputStream;
import com.martiansoftware.nailgun.NGSecurityManager;
import com.martiansoftware.nailgun.NGServer;
import com.martiansoftware.nailgun.NGSessionPool;
import com.martiansoftware.nailgun.ThreadLocalInputStream;
import com.martiansoftware.nailgun.ThreadLocalPrintStream;
import java.io.DataInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.tools.ant.ExitException;

class NGSession
extends Thread {
    private NGServer server = null;
    private NGSessionPool sessionPool = null;
    private Object lock = new Object();
    private Socket nextSocket = null;
    private boolean done = false;
    private long instanceNumber = 0L;
    private static Object sharedLock = new Object();
    private static long instanceCounter = 0L;
    private static Class[] mainSignature = new Class[1];
    private static Class[] nailMainSignature;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NGSession(NGSessionPool nGSessionPool, NGServer nGServer) {
        this.sessionPool = nGSessionPool;
        this.server = nGServer;
        Object object = sharedLock;
        synchronized (object) {
            this.instanceNumber = ++instanceCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.done = true;
        Object object = this.lock;
        synchronized (object) {
            this.nextSocket = null;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Socket socket) {
        Object object = this.lock;
        synchronized (object) {
            this.nextSocket = socket;
            this.lock.notify();
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket nextSocket() {
        Socket socket = null;
        Object object = this.lock;
        synchronized (object) {
            socket = this.nextSocket;
            while (!this.done && socket == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.done = true;
                }
                socket = this.nextSocket;
            }
            this.nextSocket = null;
        }
        return socket;
    }

    @Override
    public void run() {
        this.updateThreadName(null);
        Socket socket = this.nextSocket();
        while (socket != null) {
            try {
                block23: {
                    Object[] objectArray;
                    Object object;
                    Object object2;
                    byte[] byArray = new byte[5];
                    DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                    OutputStream outputStream = socket.getOutputStream();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Properties properties = new Properties();
                    String string = null;
                    String string2 = null;
                    while (string2 == null) {
                        dataInputStream.readFully(byArray);
                        long l = LongUtils.fromArray(byArray, 0);
                        char c = (char)byArray[4];
                        object2 = new byte[(int)l];
                        dataInputStream.readFully((byte[])object2);
                        object = new String((byte[])object2, "US-ASCII");
                        switch (c) {
                            case 'A': {
                                arrayList.add((String)object);
                                break;
                            }
                            case 'E': {
                                int n = ((String)object).indexOf(61);
                                if (n > 0) {
                                    properties.setProperty(((String)object).substring(0, n), ((String)object).substring(n + 1));
                                }
                                objectArray = ((String)object).substring(0, n);
                                break;
                            }
                            case 'C': {
                                string2 = object;
                                break;
                            }
                            case 'D': {
                                string = object;
                                break;
                            }
                        }
                    }
                    this.updateThreadName(socket.getInetAddress().getHostAddress() + ": " + string2);
                    NGInputStream nGInputStream = new NGInputStream(dataInputStream);
                    PrintStream printStream = new PrintStream(new NGOutputStream(outputStream, '1'));
                    PrintStream printStream2 = new PrintStream(new NGOutputStream(outputStream, '2'));
                    object2 = new PrintStream(new NGOutputStream(outputStream, 'X'));
                    ((ThreadLocalInputStream)System.in).init(nGInputStream);
                    ((ThreadLocalPrintStream)System.out).init(printStream);
                    ((ThreadLocalPrintStream)System.err).init(printStream2);
                    try {
                        object = this.server.getAliasManager().getAlias(string2);
                        Class clazz = null;
                        clazz = object != null ? ((Alias)object).getAliasedClass() : (this.server.allowsNailsByClassName() ? Class.forName(string2) : this.server.getDefaultNailClass());
                        objectArray = new Object[1];
                        Method method = null;
                        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                        try {
                            method = clazz.getMethod("nailMain", nailMainSignature);
                            NGContext nGContext = new NGContext();
                            nGContext.setArgs(stringArray);
                            nGContext.in = nGInputStream;
                            nGContext.out = printStream;
                            nGContext.err = printStream2;
                            nGContext.setCommand(string2);
                            nGContext.setExitStream((PrintStream)object2);
                            nGContext.setNGServer(this.server);
                            nGContext.setEnv(properties);
                            nGContext.setInetAddress(socket.getInetAddress());
                            nGContext.setPort(socket.getPort());
                            nGContext.setWorkingDirectory(string);
                            objectArray[0] = nGContext;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (method == null) {
                            method = clazz.getMethod("main", mainSignature);
                            objectArray[0] = stringArray;
                        }
                        if (method == null) break block23;
                        this.server.nailStarted(clazz);
                        NGSecurityManager.setExit((PrintStream)object2);
                        try {
                            method.invoke(null, objectArray);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw invocationTargetException.getCause();
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.server.nailFinished(clazz);
                        }
                        ((PrintStream)object2).println(0);
                    }
                    catch (ExitException exitException) {
                        ((PrintStream)object2).println(exitException.getStatus());
                        this.server.out.println(Thread.currentThread().getName() + " exited with status " + exitException.getStatus());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        ((PrintStream)object2).println(899);
                    }
                }
                socket.close();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            ((ThreadLocalInputStream)System.in).init(null);
            ((ThreadLocalPrintStream)System.out).init(null);
            ((ThreadLocalPrintStream)System.err).init(null);
            this.updateThreadName(null);
            this.sessionPool.give(this);
            socket = this.nextSocket();
        }
    }

    private void updateThreadName(String string) {
        this.setName("NGSession " + this.instanceNumber + ": " + (string == null ? "(idle)" : string));
    }

    static {
        NGSession.mainSignature[0] = String[].class;
        nailMainSignature = new Class[1];
        NGSession.nailMainSignature[0] = NGContext.class;
    }
}

