/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.LongUtils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class NGInputStream
extends FilterInputStream {
    private byte[] header = new byte[5];
    private boolean eof = false;
    private long remaining = 0L;

    public NGInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private void readHeader() throws IOException {
        if (this.eof) {
            return;
        }
        int n = 0;
        for (int i = this.in.read(this.header); i < 5; i += n) {
            n = this.in.read(this.header, i, 5 - i);
            if (n >= 0) continue;
            this.eof = true;
            return;
        }
        switch (this.header[4]) {
            case 48: {
                this.remaining = LongUtils.fromArray(this.header, 0);
                break;
            }
            case 46: {
                this.eof = true;
                break;
            }
            default: {
                throw new IOException("Unknown stream type: " + (char)this.header[4]);
            }
        }
    }

    @Override
    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        if (this.remaining > 0L) {
            return this.in.available();
        }
        return Math.max(0, this.in.available() - 5);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.header, 0, 1) == -1 ? -1 : this.header[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.remaining == 0L) {
            this.readHeader();
        }
        if (this.eof) {
            return -1;
        }
        int n3 = Math.min((int)this.remaining, n2);
        int n4 = this.in.read(byArray, n, n3);
        this.remaining -= (long)n4;
        return n4;
    }
}

