[:section#mottos
 [:h2 "★ Three Mottos"]

 [:p "When using Speculoos, remember these three Mottos:"
  [:ol
   [:li "Validate scalars separately from validating collections."]
   [:li "Shape the specification to mimic the data."]
   [:li "Ignore un-paired predicates and un-paired datums."]]]

 [:p "Speculoos provides functions for validating " [:a {:href "#scalar"} "scalars"] " (integers, strings, booleans, etc.) contained within a heterogeneous, arbitrarily-nested data structure, and another, distinct group of functions for validating properties of those nested " [:a {:href "#HANDS"} "collections"] " (vectors, maps, sets, etc.). Validating scalars separately from validating collections carries several advantages. First, it's simpler. Libraries that validate scalars and collections with one specification tend to require a mini-language that mixes identities and quantities (e.g., regular expression-like syntax). Modifying, combining, and subsetting those specifications might be non-intuitive. In contrast, by validating scalars separately from collections, Speculoos can consume much simpler specifications composed of regular Clojure data structures containing regular Clojure predicate functions. We can inspect and manipulate those specifications with any familiar Clojure collection-handling function, such as " [:code "assoc-in"] ". No macros necessary. Second, specifying scalars separately from specifying collections offers mental clarity about what's going on. Our predicates will only ever apply to a scalar, or to a collection, never both. And our scalar predicate doesn't have to know anything about the quantity or location of the element. Third, we only need to specify as much, or as little, as necessary. If we only want to validate a few scalars, we aren't forced to specify a property concerning a collection."]

 [:p "Speculoos aims to make composing specifications straightforward. To that end, specifications mimic the shape of the data they describe. A Speculoos specification is merely an arrangement of nested vectors, lists, maps, sequences, and sets that contain predicate functions. Those predicates are arranged in a pattern that instruct the validation functions where to apply the predicates. The specification for a vector is a vector. Predicates are applied to the scalars in-order. The specification for a map, is itself a map. Predicates are applied to the scalars at the same key. There's a nearly one-to-one correspondence between the shape of the data and the shape of the specification. In fact, a solid strategy for creating a specification is to copy-paste the data, delete the contents, and then, using that as a template, replace the elements with predicates. Such a specification is straightforward to peek at by eye — merely evaluate them and they'll display themselves at our " [:span.small-caps "repl"] " — but they're also amenable to alteration. We can use our favorite Clojure data wrangling functions to tighten, relax, or remove portions of a Speculoos specification. " [:code "assoc-in"] ", " [:code "update-in"] ", and " [:code "dissoc"] " are our friends."]

 [:p "Speculoos provides flexibility, power, optionality, and re-usability of specifications by ignoring datums that do not have a corresponding predicate in the specification and ignoring predicates that do not have a corresponding datum in the data. Maybe at our job in an assembly line, we only care about some slice of a large chunk of data. Supplying predicates for only a subset of datums allows us to only validate those specified datums while being agnostic towards the other datums. Going in the other direction, maybe somebody shared a giant, sprawling specification that describes a myriad of data about a person, their postal address, their contact info, etc. Because a Speculoos specification is just a data structure with regular predicates, we can, on-the-fly, " [:code "get-in"] " the portion relevant to postal addresses and apply that to our particular instances of address data. Speculoos lets us specify exactly what elements we'd like to validate. No more, no less."]]