[:section#glossary
 [:h2 "Glossary"]
 [:dl
  [:dt#element "element"]
  [:dd [:p "A thing contained within a collection, either a scalar value or another nested collection."]]

  [:dt#HANDS "heterogeneous, arbitrarily-nested data structure"]
  [:dd [:p "Exactly one Clojure collection (vector, map, list, sequence, or set) with zero or more "
        [:a {:href "#element"} "elements"]
        ", nested to any depth."]]

  [:dt#non-term-seq "non-terminating sequence"]
  [:dd [:p "One of " [:code "clojure.lang.{Cycle,Iterate,LazySeq,LongRange,Range,Repeat}"] " that may or may not be realized, and possibly infinite. (I am not aware of any way to determine if such a sequence is infinite, so Speculoos treats them as if they are.)"]]

  [:dt#path "path"]
  [:dd
   [:p "A series of values that unambiguously navigates to a single "
    [:a {:href "#element"} "element"]
    " (scalar or sub-collection) in a "
    [:a {:href "#HANDS"} "heterogeneous, arbitrarily-nested data structure"]
    ". In the context of the Speculoos library, the series of values comprising a path is generated by the "
    [:code "all-paths"]
    " function and consumed by the "
    [:code "validate-…"]
    " functions. Almost identical to the second argument of "
    [:a {:href "https://clojure.github.io/clojure/clojure.core-api.html#clojure.core/get-in"} [:code "clojure.core/get-in"]]
    ", but with more generality."]

   [:p "Elements of vectors, lists, and sequences are addressed by zero-indexed integers. Map values are addressed by their keys, which are often keywords, but can be any data type, including integers, or composite types. Set members are addressed by their identities. Nested collections contained in a set can indeed be addressed: the path vector itself contains the collections. An empty vector "
    [:code "[]"]
    " addresses the outermost, containing collection."]]

  [:dt#predicate "predicate"]
  [:dd [:p "A function, or something that implements "
        [:code "IFn"]
        ", like a set, that returns a truthy or falsey value.  In most instances, a predicate is a function of one argument. Some Speculoos functions, such as "
        [:code "validate-scalars"]
        " and "
        [:code "valid-scalars?"]
        " also regard a regular expression as a competent predicate."]]

  [:dt#relationship "relationship"]
  [:dd [:p "A human- and machine-readable declaration about the congruence between two elements. Specifically, Speculoos function validation may involve specifying a relationship between the function's argument and the function's return value."]]

  [:dt#scalar "scalar"]
  [:dd [:p "A single, non-divisible datum, such as an integer, string, boolean, etc. Essentially, a shorter term for " [:em "non-collection"] "."]]

  [:dt#specification "specification"]
  [:dd [:p "A human- and machine-readable declaration about properties of data, composed of a " [:a {:href "#HANDS"} "heterogeneous, arbitrarily-nested data collection"] " and " [:a {:href "#predicate"} "predicates"] "."]]

  [:dt#validate "validate"]
  [:dd [:p "An action that returns an exhaustive listing of all datum+predicate pairs, their paths, and whether the datum satisfies the predicate. Note: Validation requires "
        [:em "two"]
        " components, a datum and a predicate. Any unpaired datum or any unpaired predicate, will not participate in validation."]]

  [:dt#valid "valid?"]
  [:dd [:p "An action that returns "
        [:code "true"]
        " if all paired datums satisfy their predicates during a validation, "
        [:code "false"]
        " otherwise. Note: A validation operation's result is considered "
        [:em "valid"]
        " if there are zero datum+predicates."]]]]