[:section#usage
 [:h2 "Usage"]

 [:p "Clojure's "
  [:code "extend-protocol"]
  " doesn't provide a way to avoid "
  [:a {:href "https://github.com/weavejester/compojure/blob/22c56a627522f3343026c3a773630713e1e00eae/src/compojure/response.clj#L67-L73"}
   "repetitive"]
  " "
  [:a {:href "https://github.com/weavejester/ring-refresh/blob/3065d915afe043c1295b1dde80f91b006878f7c6/src/ring/middleware/refresh.clj#L26-L29"}
   "implementations"]
  ". The singular function of this library is one way avoid that repetition.
Instead of repetitive type+implementation pairs, "
  [:code "multi-extend-protocol"]
  " consumes a series of types sharing a common implementation, followed by the
 actual implementation."]

 [:p "Let's pretend we defined "
  [:code "OurProtocol"]
  " to consist of two methods, "
  [:code "foo"]
  " and "
  [:code "bar"]
  ". We supply a series of types followed by the implementation."]

 [:pre [:code
        "(multi-extend-protocol OurProtocol
  AType
  BType
  CClass
  (foo [x] x)
  (bar [y] y))"]]

 [:p "...expands to..."]

 [:pre [:code
        "(extend-protocol OurProtocol
  AType
  (foo [x] x)
  (bar [y] y)

  BType
  (foo [x] x)
  (bar [y] y)

  CClass
  (foo [x] x)
  (bar [y] y))"]]

 [:p "Investigate weirdness with "
  [:a {:href "https://clojure.github.io/clojure/clojure.core-api.html#clojure.core/macroexpand-1"}
   [:code "macroexpand-1"]]
  "."]

 [:p "And note: "
  [:code "multi-extend-protocol"]
  " inherits "
  [:code "extend-protocol"]
  "'s pattern of defining methods: "
  [:code "("
   [:em "function‑name"]
   " ["
   [:em "args"]
   "] "
   [:em "body"]
   ")"]
  ", without an explicit "
  [:code "fn"]
  "."]]

