(defproject com.sagevisuals/extended-extend-protocol "0-SNAPSHOT1"
  :description "A Clojure macro to extend a protocol to multiple types with identical implementations"
  :url "https://github.com/blosavio/extended-extend-protocol"
  :license {:name "MIT License"
            :url "https://opensource.org/license/mit"
            :distribution :repo}
  :dependencies [[org.clojure/clojure "1.12.4"]]
  :repl-options {:init-ns extended-extend-protocol.core}
  :main extended-extend-protocol.core
  :plugins []
  :profiles {:dev {:dependencies [[com.sagevisuals/chlog "5"]
                                  [com.sagevisuals/readmoi "6"]
                                  [criterium "0.4.6"]]
                   :plugins [[dev.weavejester/lein-cljfmt "0.12.0"]
                             [lein-codox "0.10.8"]]
                   :jvm-opts ["-Djdk.attach.allowAttachSelf"
                              "-XX:+UnlockDiagnosticVMOptions"
                              "-XX:+DebugNonSafepoints"
                              "-Dclj-async-profiler.output-dir=./resources/profiler_data/"]}
             :benchmark {:jvm-opts ["-XX:+TieredCompilation"
                                    "-XX:TieredStopAtLevel=4"]}
             :repl {}}
  :aliases {"readmoi" ["run" "-m" "readmoi-generator"]
            "chlog" ["run" "-m" "chlog-generator"]}
  :codox {:metadata {:doc/format :markdown}
          :namespaces [#"^extended-extend-protocol\.(?!scratch)"]
          :target-path "doc"
          :output-path "doc"
          :doc-files []
          :source-uri "https://github.com/blosavio/extended-extend-protocol/blob/main/{filepath}#L{line}"
          :html {:transforms [[:div.sidebar.primary] [:append [:ul.index-link [:li.depth-1 [:a {:href "https://github.com/blosavio/extended-extend-protocol"} "Project Home"]]]]]}
          :project {:name "extended-extend-protocol" :version "version 0"}}
  :scm {:name "git" :url "https://github.com/blosavio/extended-extend-protocol"})

