
  <body>
    <a href="https://clojars.org/com.sagevisuals/extended-extend-protocol"><img src=
    "https://img.shields.io/clojars/v/com.sagevisuals/extended-extend-protocol.svg"></a><br>
    <a href="#setup">Setup</a><br>
    <a href="https://blosavio.github.io/extended-extend-protocol/index.html">API</a><br>
    <a href="https://github.com/blosavio/extended-extend-protocol/blob/main/changelog.md">Changelog</a><br>
    <a href="#usage">Usage</a><br>
    <a href="#alternatives">Alternatives</a><br>
    <a href="https://github.com/blosavio">Contact</a><br>
    <h1>
      Extended `extend-protocol`
    </h1><em>A Clojure macro to extend a procotol to multplie types with identical implementations</em><br>
    <section id="setup">
      <h2>
        Setup
      </h2>
      <h3>
        Leiningen/Boot
      </h3>
      <pre><code>[com.sagevisuals/extended-extend-protocol &quot;0-SNAPSHOT0&quot;]</code></pre>
      <h3>
        Clojure CLI/deps.edn
      </h3>
      <pre><code>com.sagevisuals/extended-extend-protocol {:mvn/version &quot;0-SNAPSHOT0&quot;}</code></pre>
      <h3>
        Require
      </h3>
      <pre><code>(require &apos;[extended-extend-protocol.core :refer [multi-extend-protocol]])</code></pre>
    </section>
    <section id="usage">
      <h2>
        Usage
      </h2>
      <p>
        Clojure&apos;s <code>extend-protocol</code> doesn&apos;t provide a way to avoid <a href=
        "https://github.com/weavejester/compojure/blob/22c56a627522f3343026c3a773630713e1e00eae/src/compojure/response.clj#L67-L73">repetitive</a> <a href=
        "https://github.com/weavejester/ring-refresh/blob/3065d915afe043c1295b1dde80f91b006878f7c6/src/ring/middleware/refresh.clj#L26-L29">implementations</a>.
        The singular function of this library is one way avoid that repetition. Instead of repetitive type+implementation pairs,
        <code>multi-extend-protocol</code> consumes a series of types sharing a common implementation, followed by the &nbsp;actual implementation.
      </p>
      <p>
        Let&apos;s pretend we defined <code>OurProtocol</code> to consist of two methods, <code>foo</code> and <code>bar</code>. We supply a series of types
        followed by the implementation.
      </p>
      <pre><code>(multi-extend-protocol OurProtocol
&nbsp; AType
&nbsp; BType
&nbsp; CClass
&nbsp; (foo [x] x)
&nbsp; (bar [y] y))</code></pre>
      <p>
        ...expands to...
      </p>
      <pre><code>(extend-protocol OurProtocol
&nbsp; AType
&nbsp; (foo [x] x)
&nbsp; (bar [y] y)

&nbsp; BType
&nbsp; (foo [x] x)
&nbsp; (bar [y] y)

&nbsp; CClass
&nbsp; (foo [x] x)
&nbsp; (bar [y] y))</code></pre>
      <p>
        Investigate weirdness with <a href="https://clojure.github.io/clojure/clojure.core-api.html#clojure.core/macroexpand-1"><code>macroexpand-1</code></a>.
      </p>
    </section>
    <section id="alternatives">
      <h2>
        Alternatives
      </h2>
      <ul>
        <li>
          <p>
            Clojure&apos;s <a href="https://clojure.github.io/clojure/clojure.core-api.html#clojure.core/extend">extend</a> function and <a href=
            "https://github.com/clojure/clojure/blob/a3fa897590f70207eea3573759739810f2b6ab6c/src/clj/clojure/java/io.clj#L167-L296">method maps</a>.
          </p>
        </li>
        <li>Write your own little macro.
        </li>
      </ul>
    </section><br>
    <h2>
      License
    </h2>
    <p></p>
    <p>
      This program and the accompanying materials are made available under the terms of the <a href="https://opensource.org/license/MIT">MIT License</a>.
    </p>
    <p></p>
    <p id="page-footer">
      Copyright © 2024–2025 Brad Losavio.<br>
      Compiled by <a href="https://github.com/blosavio/readmoi">ReadMoi</a> on 2025 December 29.<span id="uuid"><br>
      719588cc-c548-4a75-818d-bf6496772d19</span>
    </p>
  </body>
</html>
