(ns s-exp.legba.middleware
  (:require [exoscale.ex :as ex]
            [s-exp.legba.request :as request]
            [s-exp.legba.response :as response]))

(defn wrap-validation
  "Takes a regular RING handler returns a handler that will apply openapi
  validation from the supplied `schema` for a given `method` and `path`"
  [handler schema method path opts]
  (let [sub-schema (get-in schema [:openapi-schema "paths" path (name method)])]
    (-> (fn [{:as request :keys [path-params]}]
          (let [request (request/conform-request
                         (cond-> request
                           path-params
                           (assoc :path-params path-params))
                         schema
                         sub-schema
                         opts)
                response (handler request)]
            (response/conform-response response
                                       schema
                                       sub-schema
                                       opts)))
        (vary-meta assoc
                   :schema schema
                   :sub-schema sub-schema))))

(defmulti ex->response
  #(some-> % ex/ex-type)
  :hierarchy ex/hierarchy)

(defmethod ex->response
  :s-exp.legba/invalid
  [e]
  (let [data (ex-data e)]
    {:status 400
     :content-type "application/json"
     :body (assoc data :message (ex-message e))}))

(defn wrap-error-response
  [handler]
  (fn [req]
    (ex/try+
      (handler req)
      #_{:clj-kondo/ignore [:unresolved-symbol]}
      (catch :exoscale.ex/invalid _
        #_{:clj-kondo/ignore [:unresolved-symbol]}
        (ex->response &ex)))))
