goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_48900 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_48900(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_48904 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_48904(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__47597 = coll;
var G__47598 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__47597,G__47598) : shadow.dom.lazy_native_coll_seq.call(null,G__47597,G__47598));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__47623 = arguments.length;
switch (G__47623) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__47637 = arguments.length;
switch (G__47637) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__47645 = arguments.length;
switch (G__47645) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__47657 = arguments.length;
switch (G__47657) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__47676 = arguments.length;
switch (G__47676) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__47691 = arguments.length;
switch (G__47691) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e47703){if((e47703 instanceof Object)){
var e = e47703;
return console.log("didnt support attachEvent",el,e);
} else {
throw e47703;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__47714 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__47715 = null;
var count__47716 = (0);
var i__47717 = (0);
while(true){
if((i__47717 < count__47716)){
var el = chunk__47715.cljs$core$IIndexed$_nth$arity$2(null,i__47717);
var handler_48939__$1 = ((function (seq__47714,chunk__47715,count__47716,i__47717,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__47714,chunk__47715,count__47716,i__47717,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_48939__$1);


var G__48940 = seq__47714;
var G__48941 = chunk__47715;
var G__48942 = count__47716;
var G__48943 = (i__47717 + (1));
seq__47714 = G__48940;
chunk__47715 = G__48941;
count__47716 = G__48942;
i__47717 = G__48943;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__47714);
if(temp__5804__auto__){
var seq__47714__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47714__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__47714__$1);
var G__48944 = cljs.core.chunk_rest(seq__47714__$1);
var G__48945 = c__5568__auto__;
var G__48946 = cljs.core.count(c__5568__auto__);
var G__48947 = (0);
seq__47714 = G__48944;
chunk__47715 = G__48945;
count__47716 = G__48946;
i__47717 = G__48947;
continue;
} else {
var el = cljs.core.first(seq__47714__$1);
var handler_48948__$1 = ((function (seq__47714,chunk__47715,count__47716,i__47717,el,seq__47714__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__47714,chunk__47715,count__47716,i__47717,el,seq__47714__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_48948__$1);


var G__48952 = cljs.core.next(seq__47714__$1);
var G__48953 = null;
var G__48954 = (0);
var G__48955 = (0);
seq__47714 = G__48952;
chunk__47715 = G__48953;
count__47716 = G__48954;
i__47717 = G__48955;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__47740 = arguments.length;
switch (G__47740) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__47773 = cljs.core.seq(events);
var chunk__47774 = null;
var count__47775 = (0);
var i__47776 = (0);
while(true){
if((i__47776 < count__47775)){
var vec__47808 = chunk__47774.cljs$core$IIndexed$_nth$arity$2(null,i__47776);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47808,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47808,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__48972 = seq__47773;
var G__48973 = chunk__47774;
var G__48974 = count__47775;
var G__48975 = (i__47776 + (1));
seq__47773 = G__48972;
chunk__47774 = G__48973;
count__47775 = G__48974;
i__47776 = G__48975;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__47773);
if(temp__5804__auto__){
var seq__47773__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47773__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__47773__$1);
var G__48978 = cljs.core.chunk_rest(seq__47773__$1);
var G__48979 = c__5568__auto__;
var G__48980 = cljs.core.count(c__5568__auto__);
var G__48981 = (0);
seq__47773 = G__48978;
chunk__47774 = G__48979;
count__47775 = G__48980;
i__47776 = G__48981;
continue;
} else {
var vec__47817 = cljs.core.first(seq__47773__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47817,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47817,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__48983 = cljs.core.next(seq__47773__$1);
var G__48984 = null;
var G__48985 = (0);
var G__48986 = (0);
seq__47773 = G__48983;
chunk__47774 = G__48984;
count__47775 = G__48985;
i__47776 = G__48986;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__47826 = cljs.core.seq(styles);
var chunk__47827 = null;
var count__47828 = (0);
var i__47829 = (0);
while(true){
if((i__47829 < count__47828)){
var vec__47851 = chunk__47827.cljs$core$IIndexed$_nth$arity$2(null,i__47829);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47851,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47851,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__48987 = seq__47826;
var G__48988 = chunk__47827;
var G__48989 = count__47828;
var G__48990 = (i__47829 + (1));
seq__47826 = G__48987;
chunk__47827 = G__48988;
count__47828 = G__48989;
i__47829 = G__48990;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__47826);
if(temp__5804__auto__){
var seq__47826__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47826__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__47826__$1);
var G__48994 = cljs.core.chunk_rest(seq__47826__$1);
var G__48995 = c__5568__auto__;
var G__48996 = cljs.core.count(c__5568__auto__);
var G__48997 = (0);
seq__47826 = G__48994;
chunk__47827 = G__48995;
count__47828 = G__48996;
i__47829 = G__48997;
continue;
} else {
var vec__47864 = cljs.core.first(seq__47826__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47864,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47864,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__48998 = cljs.core.next(seq__47826__$1);
var G__48999 = null;
var G__49000 = (0);
var G__49001 = (0);
seq__47826 = G__48998;
chunk__47827 = G__48999;
count__47828 = G__49000;
i__47829 = G__49001;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__47885_49002 = key;
var G__47885_49003__$1 = (((G__47885_49002 instanceof cljs.core.Keyword))?G__47885_49002.fqn:null);
switch (G__47885_49003__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_49011 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_49011,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_49011,"aria-");
}
})())){
el.setAttribute(ks_49011,value);
} else {
(el[ks_49011] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__47911){
var map__47912 = p__47911;
var map__47912__$1 = cljs.core.__destructure_map(map__47912);
var props = map__47912__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47912__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__47913 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47913,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47913,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47913,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__47917 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__47917,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__47917;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__47920 = arguments.length;
switch (G__47920) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__47923){
var vec__47924 = p__47923;
var seq__47925 = cljs.core.seq(vec__47924);
var first__47926 = cljs.core.first(seq__47925);
var seq__47925__$1 = cljs.core.next(seq__47925);
var nn = first__47926;
var first__47926__$1 = cljs.core.first(seq__47925__$1);
var seq__47925__$2 = cljs.core.next(seq__47925__$1);
var np = first__47926__$1;
var nc = seq__47925__$2;
var node = vec__47924;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__47927 = nn;
var G__47928 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__47927,G__47928) : create_fn.call(null,G__47927,G__47928));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__47932 = nn;
var G__47933 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__47932,G__47933) : create_fn.call(null,G__47932,G__47933));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__47940 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47940,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47940,(1),null);
var seq__47944_49057 = cljs.core.seq(node_children);
var chunk__47945_49058 = null;
var count__47946_49059 = (0);
var i__47947_49060 = (0);
while(true){
if((i__47947_49060 < count__47946_49059)){
var child_struct_49061 = chunk__47945_49058.cljs$core$IIndexed$_nth$arity$2(null,i__47947_49060);
var children_49062 = shadow.dom.dom_node(child_struct_49061);
if(cljs.core.seq_QMARK_(children_49062)){
var seq__47996_49066 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49062));
var chunk__47998_49067 = null;
var count__47999_49068 = (0);
var i__48000_49069 = (0);
while(true){
if((i__48000_49069 < count__47999_49068)){
var child_49072 = chunk__47998_49067.cljs$core$IIndexed$_nth$arity$2(null,i__48000_49069);
if(cljs.core.truth_(child_49072)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49072);


var G__49074 = seq__47996_49066;
var G__49075 = chunk__47998_49067;
var G__49076 = count__47999_49068;
var G__49077 = (i__48000_49069 + (1));
seq__47996_49066 = G__49074;
chunk__47998_49067 = G__49075;
count__47999_49068 = G__49076;
i__48000_49069 = G__49077;
continue;
} else {
var G__49081 = seq__47996_49066;
var G__49082 = chunk__47998_49067;
var G__49083 = count__47999_49068;
var G__49084 = (i__48000_49069 + (1));
seq__47996_49066 = G__49081;
chunk__47998_49067 = G__49082;
count__47999_49068 = G__49083;
i__48000_49069 = G__49084;
continue;
}
} else {
var temp__5804__auto___49085 = cljs.core.seq(seq__47996_49066);
if(temp__5804__auto___49085){
var seq__47996_49086__$1 = temp__5804__auto___49085;
if(cljs.core.chunked_seq_QMARK_(seq__47996_49086__$1)){
var c__5568__auto___49087 = cljs.core.chunk_first(seq__47996_49086__$1);
var G__49088 = cljs.core.chunk_rest(seq__47996_49086__$1);
var G__49089 = c__5568__auto___49087;
var G__49090 = cljs.core.count(c__5568__auto___49087);
var G__49091 = (0);
seq__47996_49066 = G__49088;
chunk__47998_49067 = G__49089;
count__47999_49068 = G__49090;
i__48000_49069 = G__49091;
continue;
} else {
var child_49092 = cljs.core.first(seq__47996_49086__$1);
if(cljs.core.truth_(child_49092)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49092);


var G__49093 = cljs.core.next(seq__47996_49086__$1);
var G__49094 = null;
var G__49095 = (0);
var G__49096 = (0);
seq__47996_49066 = G__49093;
chunk__47998_49067 = G__49094;
count__47999_49068 = G__49095;
i__48000_49069 = G__49096;
continue;
} else {
var G__49097 = cljs.core.next(seq__47996_49086__$1);
var G__49098 = null;
var G__49099 = (0);
var G__49100 = (0);
seq__47996_49066 = G__49097;
chunk__47998_49067 = G__49098;
count__47999_49068 = G__49099;
i__48000_49069 = G__49100;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49062);
}


var G__49102 = seq__47944_49057;
var G__49103 = chunk__47945_49058;
var G__49104 = count__47946_49059;
var G__49105 = (i__47947_49060 + (1));
seq__47944_49057 = G__49102;
chunk__47945_49058 = G__49103;
count__47946_49059 = G__49104;
i__47947_49060 = G__49105;
continue;
} else {
var temp__5804__auto___49107 = cljs.core.seq(seq__47944_49057);
if(temp__5804__auto___49107){
var seq__47944_49108__$1 = temp__5804__auto___49107;
if(cljs.core.chunked_seq_QMARK_(seq__47944_49108__$1)){
var c__5568__auto___49112 = cljs.core.chunk_first(seq__47944_49108__$1);
var G__49113 = cljs.core.chunk_rest(seq__47944_49108__$1);
var G__49114 = c__5568__auto___49112;
var G__49115 = cljs.core.count(c__5568__auto___49112);
var G__49116 = (0);
seq__47944_49057 = G__49113;
chunk__47945_49058 = G__49114;
count__47946_49059 = G__49115;
i__47947_49060 = G__49116;
continue;
} else {
var child_struct_49117 = cljs.core.first(seq__47944_49108__$1);
var children_49118 = shadow.dom.dom_node(child_struct_49117);
if(cljs.core.seq_QMARK_(children_49118)){
var seq__48020_49119 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49118));
var chunk__48022_49120 = null;
var count__48023_49121 = (0);
var i__48024_49122 = (0);
while(true){
if((i__48024_49122 < count__48023_49121)){
var child_49125 = chunk__48022_49120.cljs$core$IIndexed$_nth$arity$2(null,i__48024_49122);
if(cljs.core.truth_(child_49125)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49125);


var G__49126 = seq__48020_49119;
var G__49127 = chunk__48022_49120;
var G__49128 = count__48023_49121;
var G__49129 = (i__48024_49122 + (1));
seq__48020_49119 = G__49126;
chunk__48022_49120 = G__49127;
count__48023_49121 = G__49128;
i__48024_49122 = G__49129;
continue;
} else {
var G__49130 = seq__48020_49119;
var G__49131 = chunk__48022_49120;
var G__49132 = count__48023_49121;
var G__49133 = (i__48024_49122 + (1));
seq__48020_49119 = G__49130;
chunk__48022_49120 = G__49131;
count__48023_49121 = G__49132;
i__48024_49122 = G__49133;
continue;
}
} else {
var temp__5804__auto___49134__$1 = cljs.core.seq(seq__48020_49119);
if(temp__5804__auto___49134__$1){
var seq__48020_49135__$1 = temp__5804__auto___49134__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48020_49135__$1)){
var c__5568__auto___49136 = cljs.core.chunk_first(seq__48020_49135__$1);
var G__49137 = cljs.core.chunk_rest(seq__48020_49135__$1);
var G__49138 = c__5568__auto___49136;
var G__49139 = cljs.core.count(c__5568__auto___49136);
var G__49140 = (0);
seq__48020_49119 = G__49137;
chunk__48022_49120 = G__49138;
count__48023_49121 = G__49139;
i__48024_49122 = G__49140;
continue;
} else {
var child_49141 = cljs.core.first(seq__48020_49135__$1);
if(cljs.core.truth_(child_49141)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49141);


var G__49143 = cljs.core.next(seq__48020_49135__$1);
var G__49144 = null;
var G__49145 = (0);
var G__49146 = (0);
seq__48020_49119 = G__49143;
chunk__48022_49120 = G__49144;
count__48023_49121 = G__49145;
i__48024_49122 = G__49146;
continue;
} else {
var G__49147 = cljs.core.next(seq__48020_49135__$1);
var G__49149 = null;
var G__49150 = (0);
var G__49151 = (0);
seq__48020_49119 = G__49147;
chunk__48022_49120 = G__49149;
count__48023_49121 = G__49150;
i__48024_49122 = G__49151;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49118);
}


var G__49152 = cljs.core.next(seq__47944_49108__$1);
var G__49153 = null;
var G__49154 = (0);
var G__49155 = (0);
seq__47944_49057 = G__49152;
chunk__47945_49058 = G__49153;
count__47946_49059 = G__49154;
i__47947_49060 = G__49155;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__48078 = cljs.core.seq(node);
var chunk__48079 = null;
var count__48080 = (0);
var i__48081 = (0);
while(true){
if((i__48081 < count__48080)){
var n = chunk__48079.cljs$core$IIndexed$_nth$arity$2(null,i__48081);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49171 = seq__48078;
var G__49172 = chunk__48079;
var G__49173 = count__48080;
var G__49174 = (i__48081 + (1));
seq__48078 = G__49171;
chunk__48079 = G__49172;
count__48080 = G__49173;
i__48081 = G__49174;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__48078);
if(temp__5804__auto__){
var seq__48078__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48078__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__48078__$1);
var G__49178 = cljs.core.chunk_rest(seq__48078__$1);
var G__49179 = c__5568__auto__;
var G__49180 = cljs.core.count(c__5568__auto__);
var G__49181 = (0);
seq__48078 = G__49178;
chunk__48079 = G__49179;
count__48080 = G__49180;
i__48081 = G__49181;
continue;
} else {
var n = cljs.core.first(seq__48078__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49183 = cljs.core.next(seq__48078__$1);
var G__49184 = null;
var G__49185 = (0);
var G__49186 = (0);
seq__48078 = G__49183;
chunk__48079 = G__49184;
count__48080 = G__49185;
i__48081 = G__49186;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__48107 = arguments.length;
switch (G__48107) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__48111 = arguments.length;
switch (G__48111) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__48159 = arguments.length;
switch (G__48159) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___49218 = arguments.length;
var i__5770__auto___49219 = (0);
while(true){
if((i__5770__auto___49219 < len__5769__auto___49218)){
args__5775__auto__.push((arguments[i__5770__auto___49219]));

var G__49223 = (i__5770__auto___49219 + (1));
i__5770__auto___49219 = G__49223;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__48210_49224 = cljs.core.seq(nodes);
var chunk__48211_49225 = null;
var count__48212_49226 = (0);
var i__48213_49227 = (0);
while(true){
if((i__48213_49227 < count__48212_49226)){
var node_49228 = chunk__48211_49225.cljs$core$IIndexed$_nth$arity$2(null,i__48213_49227);
fragment.appendChild(shadow.dom._to_dom(node_49228));


var G__49229 = seq__48210_49224;
var G__49230 = chunk__48211_49225;
var G__49231 = count__48212_49226;
var G__49232 = (i__48213_49227 + (1));
seq__48210_49224 = G__49229;
chunk__48211_49225 = G__49230;
count__48212_49226 = G__49231;
i__48213_49227 = G__49232;
continue;
} else {
var temp__5804__auto___49233 = cljs.core.seq(seq__48210_49224);
if(temp__5804__auto___49233){
var seq__48210_49234__$1 = temp__5804__auto___49233;
if(cljs.core.chunked_seq_QMARK_(seq__48210_49234__$1)){
var c__5568__auto___49235 = cljs.core.chunk_first(seq__48210_49234__$1);
var G__49236 = cljs.core.chunk_rest(seq__48210_49234__$1);
var G__49237 = c__5568__auto___49235;
var G__49238 = cljs.core.count(c__5568__auto___49235);
var G__49239 = (0);
seq__48210_49224 = G__49236;
chunk__48211_49225 = G__49237;
count__48212_49226 = G__49238;
i__48213_49227 = G__49239;
continue;
} else {
var node_49240 = cljs.core.first(seq__48210_49234__$1);
fragment.appendChild(shadow.dom._to_dom(node_49240));


var G__49241 = cljs.core.next(seq__48210_49234__$1);
var G__49242 = null;
var G__49243 = (0);
var G__49244 = (0);
seq__48210_49224 = G__49241;
chunk__48211_49225 = G__49242;
count__48212_49226 = G__49243;
i__48213_49227 = G__49244;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq48206){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq48206));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__48230_49246 = cljs.core.seq(scripts);
var chunk__48231_49247 = null;
var count__48232_49248 = (0);
var i__48233_49249 = (0);
while(true){
if((i__48233_49249 < count__48232_49248)){
var vec__48242_49255 = chunk__48231_49247.cljs$core$IIndexed$_nth$arity$2(null,i__48233_49249);
var script_tag_49256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48242_49255,(0),null);
var script_body_49257 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48242_49255,(1),null);
eval(script_body_49257);


var G__49258 = seq__48230_49246;
var G__49259 = chunk__48231_49247;
var G__49260 = count__48232_49248;
var G__49261 = (i__48233_49249 + (1));
seq__48230_49246 = G__49258;
chunk__48231_49247 = G__49259;
count__48232_49248 = G__49260;
i__48233_49249 = G__49261;
continue;
} else {
var temp__5804__auto___49262 = cljs.core.seq(seq__48230_49246);
if(temp__5804__auto___49262){
var seq__48230_49263__$1 = temp__5804__auto___49262;
if(cljs.core.chunked_seq_QMARK_(seq__48230_49263__$1)){
var c__5568__auto___49264 = cljs.core.chunk_first(seq__48230_49263__$1);
var G__49265 = cljs.core.chunk_rest(seq__48230_49263__$1);
var G__49266 = c__5568__auto___49264;
var G__49267 = cljs.core.count(c__5568__auto___49264);
var G__49268 = (0);
seq__48230_49246 = G__49265;
chunk__48231_49247 = G__49266;
count__48232_49248 = G__49267;
i__48233_49249 = G__49268;
continue;
} else {
var vec__48251_49269 = cljs.core.first(seq__48230_49263__$1);
var script_tag_49270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48251_49269,(0),null);
var script_body_49271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48251_49269,(1),null);
eval(script_body_49271);


var G__49274 = cljs.core.next(seq__48230_49263__$1);
var G__49275 = null;
var G__49276 = (0);
var G__49277 = (0);
seq__48230_49246 = G__49274;
chunk__48231_49247 = G__49275;
count__48232_49248 = G__49276;
i__48233_49249 = G__49277;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__48259){
var vec__48262 = p__48259;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48262,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48262,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__48281 = arguments.length;
switch (G__48281) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__48330 = cljs.core.seq(style_keys);
var chunk__48331 = null;
var count__48332 = (0);
var i__48333 = (0);
while(true){
if((i__48333 < count__48332)){
var it = chunk__48331.cljs$core$IIndexed$_nth$arity$2(null,i__48333);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__49315 = seq__48330;
var G__49316 = chunk__48331;
var G__49317 = count__48332;
var G__49318 = (i__48333 + (1));
seq__48330 = G__49315;
chunk__48331 = G__49316;
count__48332 = G__49317;
i__48333 = G__49318;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__48330);
if(temp__5804__auto__){
var seq__48330__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48330__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__48330__$1);
var G__49319 = cljs.core.chunk_rest(seq__48330__$1);
var G__49320 = c__5568__auto__;
var G__49321 = cljs.core.count(c__5568__auto__);
var G__49322 = (0);
seq__48330 = G__49319;
chunk__48331 = G__49320;
count__48332 = G__49321;
i__48333 = G__49322;
continue;
} else {
var it = cljs.core.first(seq__48330__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__49324 = cljs.core.next(seq__48330__$1);
var G__49325 = null;
var G__49326 = (0);
var G__49327 = (0);
seq__48330 = G__49324;
chunk__48331 = G__49325;
count__48332 = G__49326;
i__48333 = G__49327;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k48371,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__48389 = k48371;
var G__48389__$1 = (((G__48389 instanceof cljs.core.Keyword))?G__48389.fqn:null);
switch (G__48389__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k48371,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__48394){
var vec__48395 = p__48394;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48395,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48395,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48370){
var self__ = this;
var G__48370__$1 = this;
return (new cljs.core.RecordIter((0),G__48370__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this48372,other48373){
var self__ = this;
var this48372__$1 = this;
return (((!((other48373 == null)))) && ((((this48372__$1.constructor === other48373.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48372__$1.x,other48373.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48372__$1.y,other48373.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48372__$1.__extmap,other48373.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k48371){
var self__ = this;
var this__5350__auto____$1 = this;
var G__48435 = k48371;
var G__48435__$1 = (((G__48435 instanceof cljs.core.Keyword))?G__48435.fqn:null);
switch (G__48435__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k48371);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__48370){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__48439 = cljs.core.keyword_identical_QMARK_;
var expr__48440 = k__5352__auto__;
if(cljs.core.truth_((pred__48439.cljs$core$IFn$_invoke$arity$2 ? pred__48439.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__48440) : pred__48439.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__48440)))){
return (new shadow.dom.Coordinate(G__48370,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__48439.cljs$core$IFn$_invoke$arity$2 ? pred__48439.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__48440) : pred__48439.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__48440)))){
return (new shadow.dom.Coordinate(self__.x,G__48370,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__48370),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__48370){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__48370,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__48381){
var extmap__5385__auto__ = (function (){var G__48459 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__48381,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__48381)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__48459);
} else {
return G__48459;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__48381),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__48381),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k48468,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__48495 = k48468;
var G__48495__$1 = (((G__48495 instanceof cljs.core.Keyword))?G__48495.fqn:null);
switch (G__48495__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k48468,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__48506){
var vec__48507 = p__48506;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48507,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48507,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48467){
var self__ = this;
var G__48467__$1 = this;
return (new cljs.core.RecordIter((0),G__48467__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this48469,other48470){
var self__ = this;
var this48469__$1 = this;
return (((!((other48470 == null)))) && ((((this48469__$1.constructor === other48470.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48469__$1.w,other48470.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48469__$1.h,other48470.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this48469__$1.__extmap,other48470.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k48468){
var self__ = this;
var this__5350__auto____$1 = this;
var G__48550 = k48468;
var G__48550__$1 = (((G__48550 instanceof cljs.core.Keyword))?G__48550.fqn:null);
switch (G__48550__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k48468);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__48467){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__48559 = cljs.core.keyword_identical_QMARK_;
var expr__48560 = k__5352__auto__;
if(cljs.core.truth_((pred__48559.cljs$core$IFn$_invoke$arity$2 ? pred__48559.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__48560) : pred__48559.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__48560)))){
return (new shadow.dom.Size(G__48467,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__48559.cljs$core$IFn$_invoke$arity$2 ? pred__48559.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__48560) : pred__48559.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__48560)))){
return (new shadow.dom.Size(self__.w,G__48467,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__48467),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__48467){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__48467,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__48489){
var extmap__5385__auto__ = (function (){var G__48595 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__48489,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__48489)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__48595);
} else {
return G__48595;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__48489),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__48489),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__49416 = (i + (1));
var G__49417 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__49416;
ret = G__49417;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__48627){
var vec__48628 = p__48627;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48628,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48628,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__48638 = arguments.length;
switch (G__48638) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__49433 = ps;
var G__49434 = (i + (1));
el__$1 = G__49433;
i = G__49434;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__48688 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48688,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48688,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48688,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__48693_49446 = cljs.core.seq(props);
var chunk__48695_49447 = null;
var count__48696_49448 = (0);
var i__48697_49449 = (0);
while(true){
if((i__48697_49449 < count__48696_49448)){
var vec__48712_49453 = chunk__48695_49447.cljs$core$IIndexed$_nth$arity$2(null,i__48697_49449);
var k_49454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48712_49453,(0),null);
var v_49455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48712_49453,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_49454);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_49454),v_49455);


var G__49461 = seq__48693_49446;
var G__49462 = chunk__48695_49447;
var G__49463 = count__48696_49448;
var G__49464 = (i__48697_49449 + (1));
seq__48693_49446 = G__49461;
chunk__48695_49447 = G__49462;
count__48696_49448 = G__49463;
i__48697_49449 = G__49464;
continue;
} else {
var temp__5804__auto___49465 = cljs.core.seq(seq__48693_49446);
if(temp__5804__auto___49465){
var seq__48693_49470__$1 = temp__5804__auto___49465;
if(cljs.core.chunked_seq_QMARK_(seq__48693_49470__$1)){
var c__5568__auto___49472 = cljs.core.chunk_first(seq__48693_49470__$1);
var G__49473 = cljs.core.chunk_rest(seq__48693_49470__$1);
var G__49474 = c__5568__auto___49472;
var G__49475 = cljs.core.count(c__5568__auto___49472);
var G__49476 = (0);
seq__48693_49446 = G__49473;
chunk__48695_49447 = G__49474;
count__48696_49448 = G__49475;
i__48697_49449 = G__49476;
continue;
} else {
var vec__48716_49478 = cljs.core.first(seq__48693_49470__$1);
var k_49479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48716_49478,(0),null);
var v_49480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48716_49478,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_49479);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_49479),v_49480);


var G__49484 = cljs.core.next(seq__48693_49470__$1);
var G__49485 = null;
var G__49486 = (0);
var G__49487 = (0);
seq__48693_49446 = G__49484;
chunk__48695_49447 = G__49485;
count__48696_49448 = G__49486;
i__48697_49449 = G__49487;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__48722 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48722,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48722,(1),null);
var seq__48728_49494 = cljs.core.seq(node_children);
var chunk__48730_49495 = null;
var count__48731_49496 = (0);
var i__48732_49497 = (0);
while(true){
if((i__48732_49497 < count__48731_49496)){
var child_struct_49498 = chunk__48730_49495.cljs$core$IIndexed$_nth$arity$2(null,i__48732_49497);
if((!((child_struct_49498 == null)))){
if(typeof child_struct_49498 === 'string'){
var text_49500 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_49500),child_struct_49498].join(''));
} else {
var children_49501 = shadow.dom.svg_node(child_struct_49498);
if(cljs.core.seq_QMARK_(children_49501)){
var seq__48756_49505 = cljs.core.seq(children_49501);
var chunk__48758_49506 = null;
var count__48759_49507 = (0);
var i__48760_49508 = (0);
while(true){
if((i__48760_49508 < count__48759_49507)){
var child_49509 = chunk__48758_49506.cljs$core$IIndexed$_nth$arity$2(null,i__48760_49508);
if(cljs.core.truth_(child_49509)){
node.appendChild(child_49509);


var G__49510 = seq__48756_49505;
var G__49511 = chunk__48758_49506;
var G__49512 = count__48759_49507;
var G__49513 = (i__48760_49508 + (1));
seq__48756_49505 = G__49510;
chunk__48758_49506 = G__49511;
count__48759_49507 = G__49512;
i__48760_49508 = G__49513;
continue;
} else {
var G__49514 = seq__48756_49505;
var G__49515 = chunk__48758_49506;
var G__49516 = count__48759_49507;
var G__49517 = (i__48760_49508 + (1));
seq__48756_49505 = G__49514;
chunk__48758_49506 = G__49515;
count__48759_49507 = G__49516;
i__48760_49508 = G__49517;
continue;
}
} else {
var temp__5804__auto___49520 = cljs.core.seq(seq__48756_49505);
if(temp__5804__auto___49520){
var seq__48756_49521__$1 = temp__5804__auto___49520;
if(cljs.core.chunked_seq_QMARK_(seq__48756_49521__$1)){
var c__5568__auto___49522 = cljs.core.chunk_first(seq__48756_49521__$1);
var G__49523 = cljs.core.chunk_rest(seq__48756_49521__$1);
var G__49524 = c__5568__auto___49522;
var G__49525 = cljs.core.count(c__5568__auto___49522);
var G__49526 = (0);
seq__48756_49505 = G__49523;
chunk__48758_49506 = G__49524;
count__48759_49507 = G__49525;
i__48760_49508 = G__49526;
continue;
} else {
var child_49527 = cljs.core.first(seq__48756_49521__$1);
if(cljs.core.truth_(child_49527)){
node.appendChild(child_49527);


var G__49528 = cljs.core.next(seq__48756_49521__$1);
var G__49529 = null;
var G__49530 = (0);
var G__49531 = (0);
seq__48756_49505 = G__49528;
chunk__48758_49506 = G__49529;
count__48759_49507 = G__49530;
i__48760_49508 = G__49531;
continue;
} else {
var G__49532 = cljs.core.next(seq__48756_49521__$1);
var G__49533 = null;
var G__49534 = (0);
var G__49535 = (0);
seq__48756_49505 = G__49532;
chunk__48758_49506 = G__49533;
count__48759_49507 = G__49534;
i__48760_49508 = G__49535;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_49501);
}
}


var G__49540 = seq__48728_49494;
var G__49541 = chunk__48730_49495;
var G__49542 = count__48731_49496;
var G__49543 = (i__48732_49497 + (1));
seq__48728_49494 = G__49540;
chunk__48730_49495 = G__49541;
count__48731_49496 = G__49542;
i__48732_49497 = G__49543;
continue;
} else {
var G__49544 = seq__48728_49494;
var G__49545 = chunk__48730_49495;
var G__49546 = count__48731_49496;
var G__49547 = (i__48732_49497 + (1));
seq__48728_49494 = G__49544;
chunk__48730_49495 = G__49545;
count__48731_49496 = G__49546;
i__48732_49497 = G__49547;
continue;
}
} else {
var temp__5804__auto___49548 = cljs.core.seq(seq__48728_49494);
if(temp__5804__auto___49548){
var seq__48728_49549__$1 = temp__5804__auto___49548;
if(cljs.core.chunked_seq_QMARK_(seq__48728_49549__$1)){
var c__5568__auto___49550 = cljs.core.chunk_first(seq__48728_49549__$1);
var G__49551 = cljs.core.chunk_rest(seq__48728_49549__$1);
var G__49552 = c__5568__auto___49550;
var G__49553 = cljs.core.count(c__5568__auto___49550);
var G__49554 = (0);
seq__48728_49494 = G__49551;
chunk__48730_49495 = G__49552;
count__48731_49496 = G__49553;
i__48732_49497 = G__49554;
continue;
} else {
var child_struct_49555 = cljs.core.first(seq__48728_49549__$1);
if((!((child_struct_49555 == null)))){
if(typeof child_struct_49555 === 'string'){
var text_49556 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_49556),child_struct_49555].join(''));
} else {
var children_49558 = shadow.dom.svg_node(child_struct_49555);
if(cljs.core.seq_QMARK_(children_49558)){
var seq__48789_49559 = cljs.core.seq(children_49558);
var chunk__48791_49560 = null;
var count__48792_49561 = (0);
var i__48793_49562 = (0);
while(true){
if((i__48793_49562 < count__48792_49561)){
var child_49563 = chunk__48791_49560.cljs$core$IIndexed$_nth$arity$2(null,i__48793_49562);
if(cljs.core.truth_(child_49563)){
node.appendChild(child_49563);


var G__49568 = seq__48789_49559;
var G__49569 = chunk__48791_49560;
var G__49570 = count__48792_49561;
var G__49571 = (i__48793_49562 + (1));
seq__48789_49559 = G__49568;
chunk__48791_49560 = G__49569;
count__48792_49561 = G__49570;
i__48793_49562 = G__49571;
continue;
} else {
var G__49575 = seq__48789_49559;
var G__49576 = chunk__48791_49560;
var G__49577 = count__48792_49561;
var G__49578 = (i__48793_49562 + (1));
seq__48789_49559 = G__49575;
chunk__48791_49560 = G__49576;
count__48792_49561 = G__49577;
i__48793_49562 = G__49578;
continue;
}
} else {
var temp__5804__auto___49583__$1 = cljs.core.seq(seq__48789_49559);
if(temp__5804__auto___49583__$1){
var seq__48789_49585__$1 = temp__5804__auto___49583__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48789_49585__$1)){
var c__5568__auto___49586 = cljs.core.chunk_first(seq__48789_49585__$1);
var G__49587 = cljs.core.chunk_rest(seq__48789_49585__$1);
var G__49588 = c__5568__auto___49586;
var G__49589 = cljs.core.count(c__5568__auto___49586);
var G__49590 = (0);
seq__48789_49559 = G__49587;
chunk__48791_49560 = G__49588;
count__48792_49561 = G__49589;
i__48793_49562 = G__49590;
continue;
} else {
var child_49591 = cljs.core.first(seq__48789_49585__$1);
if(cljs.core.truth_(child_49591)){
node.appendChild(child_49591);


var G__49595 = cljs.core.next(seq__48789_49585__$1);
var G__49596 = null;
var G__49597 = (0);
var G__49598 = (0);
seq__48789_49559 = G__49595;
chunk__48791_49560 = G__49596;
count__48792_49561 = G__49597;
i__48793_49562 = G__49598;
continue;
} else {
var G__49599 = cljs.core.next(seq__48789_49585__$1);
var G__49600 = null;
var G__49601 = (0);
var G__49602 = (0);
seq__48789_49559 = G__49599;
chunk__48791_49560 = G__49600;
count__48792_49561 = G__49601;
i__48793_49562 = G__49602;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_49558);
}
}


var G__49603 = cljs.core.next(seq__48728_49549__$1);
var G__49604 = null;
var G__49605 = (0);
var G__49606 = (0);
seq__48728_49494 = G__49603;
chunk__48730_49495 = G__49604;
count__48731_49496 = G__49605;
i__48732_49497 = G__49606;
continue;
} else {
var G__49607 = cljs.core.next(seq__48728_49549__$1);
var G__49608 = null;
var G__49609 = (0);
var G__49610 = (0);
seq__48728_49494 = G__49607;
chunk__48730_49495 = G__49608;
count__48731_49496 = G__49609;
i__48732_49497 = G__49610;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___49615 = arguments.length;
var i__5770__auto___49616 = (0);
while(true){
if((i__5770__auto___49616 < len__5769__auto___49615)){
args__5775__auto__.push((arguments[i__5770__auto___49616]));

var G__49618 = (i__5770__auto___49616 + (1));
i__5770__auto___49616 = G__49618;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq48809){
var G__48810 = cljs.core.first(seq48809);
var seq48809__$1 = cljs.core.next(seq48809);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48810,seq48809__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__48824 = arguments.length;
switch (G__48824) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__44773__auto___49635 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_48839){
var state_val_48840 = (state_48839[(1)]);
if((state_val_48840 === (1))){
var state_48839__$1 = state_48839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48839__$1,(2),once_or_cleanup);
} else {
if((state_val_48840 === (2))){
var inst_48836 = (state_48839[(2)]);
var inst_48837 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_48839__$1 = (function (){var statearr_48847 = state_48839;
(statearr_48847[(7)] = inst_48836);

return statearr_48847;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48839__$1,inst_48837);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__44577__auto__ = null;
var shadow$dom$state_machine__44577__auto____0 = (function (){
var statearr_48849 = [null,null,null,null,null,null,null,null];
(statearr_48849[(0)] = shadow$dom$state_machine__44577__auto__);

(statearr_48849[(1)] = (1));

return statearr_48849;
});
var shadow$dom$state_machine__44577__auto____1 = (function (state_48839){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_48839);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e48851){var ex__44580__auto__ = e48851;
var statearr_48852_49644 = state_48839;
(statearr_48852_49644[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_48839[(4)]))){
var statearr_48853_49645 = state_48839;
(statearr_48853_49645[(1)] = cljs.core.first((state_48839[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49646 = state_48839;
state_48839 = G__49646;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
shadow$dom$state_machine__44577__auto__ = function(state_48839){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__44577__auto____0.call(this);
case 1:
return shadow$dom$state_machine__44577__auto____1.call(this,state_48839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__44577__auto____0;
shadow$dom$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__44577__auto____1;
return shadow$dom$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_48869 = f__44774__auto__();
(statearr_48869[(6)] = c__44773__auto___49635);

return statearr_48869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
