goog.provide('re_com.debug');
goog.scope(function(){
  re_com.debug.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Returns the interesting part of component-name
 */
re_com.debug.short_component_name = (function re_com$debug$short_component_name(component_name){
return clojure.string.replace(clojure.string.replace(cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(component_name,/\./)),/_render/,""),/_/,"-");
});
/**
 * Return a version of args which is stripped of uninteresting values, suitable for logging.
 */
re_com.debug.loggable_args = (function re_com$debug$loggable_args(args){
if(cljs.core.map_QMARK_(args)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.second),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(args,new cljs.core.Keyword(null,"src","src",-1651076051),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"panel-1","panel-1",998274139),new cljs.core.Keyword(null,"panel-2","panel-2",244198907),new cljs.core.Keyword(null,"debug-as","debug-as",283322354)], 0))));
} else {
return args;
}
});
re_com.debug.__GT_attr = (function re_com$debug$__GT_attr(p__51679){
var map__51680 = p__51679;
var map__51680__$1 = cljs.core.__destructure_map(map__51680);
var args = map__51680__$1;
var src = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51680__$1,new cljs.core.Keyword(null,"src","src",-1651076051));
var debug_as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51680__$1,new cljs.core.Keyword(null,"debug-as","debug-as",283322354));
if(cljs.core.not(re_com.config.debug_QMARK_)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var rc_component = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(debug_as);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return re_com.debug.short_component_name(reagent.impl.component.component_name(reagent.core.current_component()));
}
})();
var rc_args = re_com.debug.loggable_args((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(debug_as);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return args;
}
})());
var ref_fn = (function (el){
if(cljs.core.truth_(el)){
re_com.debug.goog$module$goog$object.set(el,"__rc-args",rc_args);
} else {
}

var temp__5804__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.Keyword(null,"ref","ref",1289896967)], null));
if(cljs.core.truth_(temp__5804__auto__)){
var user_ref_fn = temp__5804__auto__;
if(cljs.core.fn_QMARK_(user_ref_fn)){
return (user_ref_fn.cljs$core$IFn$_invoke$arity$1 ? user_ref_fn.cljs$core$IFn$_invoke$arity$1(el) : user_ref_fn.call(null,el));
} else {
return null;
}
} else {
return null;
}
});
var map__51683 = src;
var map__51683__$1 = cljs.core.__destructure_map(map__51683);
var file = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51683__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51683__$1,new cljs.core.Keyword(null,"line","line",212345235));
var G__51686 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),ref_fn,new cljs.core.Keyword(null,"data-rc","data-rc",1949262543),rc_component], null);
if(cljs.core.truth_(src)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__51686,new cljs.core.Keyword(null,"data-rc-src","data-rc-src",-344701880),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''));
} else {
return G__51686;
}
}
});
re_com.debug.component_stack = (function re_com$debug$component_stack(var_args){
var G__51688 = arguments.length;
switch (G__51688) {
case 1:
return re_com.debug.component_stack.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return re_com.debug.component_stack.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(re_com.debug.component_stack.cljs$core$IFn$_invoke$arity$1 = (function (el){
return re_com.debug.component_stack.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,el);
}));

(re_com.debug.component_stack.cljs$core$IFn$_invoke$arity$2 = (function (stack,el){
if(cljs.core.not(el)){
return stack;
} else {
var component = el.dataset.rc;
var parent = el.parentElement;
return re_com.debug.component_stack.cljs$core$IFn$_invoke$arity$2(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("stack-spy",component))?stack:cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"el","el",-1618201118),el,new cljs.core.Keyword(null,"src","src",-1651076051),el.dataset.rcSrc,new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"args","args",1315556576),re_com.debug.goog$module$goog$object.get(el,"__rc-args")], null))),parent);
}
}));

(re_com.debug.component_stack.cljs$lang$maxFixedArity = 2);

re_com.debug.validate_args_problems_style = (function re_com$debug$validate_args_problems_style(){
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"min-width","min-width",1926193728),"32px",new cljs.core.Keyword(null,"min-height","min-height",398480837),"32px",new cljs.core.Keyword(null,"font-size","font-size",-1847940346),"1.4em",new cljs.core.Keyword(null,"text-align","text-align",1786091845),"center",new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),"center",new cljs.core.Keyword(null,"background","background",-863952629),"#FF4136"], null);
});
re_com.debug.h1_style = "background: #FF4136; color: white; font-size: 1.4em; padding: 3px";
re_com.debug.h2_style = "background: #0074D9; color: white; padding: 0.25em";
re_com.debug.code_style = "font-family: monospace; font-weight: bold; background: #eee; color: #333; padding: 3px";
re_com.debug.error_style = "font-weight: bold";
re_com.debug.index_style = "font-weight: bold; font-size: 1.1em";
re_com.debug.collision_icon = "\uD83D\uDCA5";
re_com.debug.gear_icon = "\u2699\uFE0F";
re_com.debug.blue_book_icon = "\uD83D\uDCD8";
re_com.debug.confused_icon = "\uD83D\uDE15";
re_com.debug.globe_icon = "\uD83C\uDF10";
re_com.debug.log_component_stack = (function re_com$debug$log_component_stack(stack){
console.groupCollapsed("\u2022 %c Component stack (click me)",re_com.debug.h2_style);

var seq__51702_51960 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (p1__51701_SHARP_,p2__51700_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p2__51700_SHARP_,new cljs.core.Keyword(null,"i","i",-1386841315),(p1__51701_SHARP_ + (1)));
}),stack));
var chunk__51703_51961 = null;
var count__51704_51962 = (0);
var i__51705_51963 = (0);
while(true){
if((i__51705_51963 < count__51704_51962)){
var map__51722_51964 = chunk__51703_51961.cljs$core$IIndexed$_nth$arity$2(null,i__51705_51963);
var map__51722_51965__$1 = cljs.core.__destructure_map(map__51722_51964);
var i_51966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51722_51965__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var el_51967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51722_51965__$1,new cljs.core.Keyword(null,"el","el",-1618201118));
var component_51968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51722_51965__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var src_51969 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51722_51965__$1,new cljs.core.Keyword(null,"src","src",-1651076051));
var args_51970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51722_51965__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_(component_51968)){
if(cljs.core.truth_(src_51969)){
var vec__51723_51972 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(src_51969,/:/);
var file_51973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51723_51972,(0),null);
var line_51974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51723_51972,(1),null);
if(cljs.core.truth_(args_51970)){
console.log(["%c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i_51966),"%c ",re_com.debug.gear_icon," %c[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(component_51968)," ...]%c in file %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file_51973),"%c at line %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_51974),"%c\n      Parameters: %O\n      DOM: %o"].join(''),re_com.debug.index_style,"",re_com.debug.code_style,"",re_com.debug.code_style,"",re_com.debug.code_style,"",args_51970,el_51967);
} else {
console.log(["%c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i_51966),"%c ",re_com.debug.gear_icon," %c[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(component_51968)," ...]%c in file %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file_51973),"%c at line %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_51974),"%c\n      DOM: %o"].join(''),re_com.debug.index_style,"",re_com.debug.code_style,"",re_com.debug.code_style,"",re_com.debug.code_style,"",el_51967);
}
} else {
console.log(["%c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i_51966),"%c ",re_com.debug.gear_icon," %c[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(component_51968)," ...]%c\n      Parameters: %O\n      DOM: %o"].join(''),re_com.debug.index_style,"",re_com.debug.code_style,"",args_51970,el_51967);
}
} else {
console.log(["%c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i_51966),"%c ",re_com.debug.globe_icon," %o"].join(''),re_com.debug.index_style,"",el_51967);
}


var G__51976 = seq__51702_51960;
var G__51977 = chunk__51703_51961;
var G__51978 = count__51704_51962;
var G__51979 = (i__51705_51963 + (1));
seq__51702_51960 = G__51976;
chunk__51703_51961 = G__51977;
count__51704_51962 = G__51978;
i__51705_51963 = G__51979;
continue;
} else {
var temp__5804__auto___51980 = cljs.core.seq(seq__51702_51960);
if(temp__5804__auto___51980){
var seq__51702_51981__$1 = temp__5804__auto___51980;
if(cljs.core.chunked_seq_QMARK_(seq__51702_51981__$1)){
var c__5568__auto___51982 = cljs.core.chunk_first(seq__51702_51981__$1);
var G__51983 = cljs.core.chunk_rest(seq__51702_51981__$1);
var G__51984 = c__5568__auto___51982;
var G__51985 = cljs.core.count(c__5568__auto___51982);
var G__51986 = (0);
seq__51702_51960 = G__51983;
chunk__51703_51961 = G__51984;
count__51704_51962 = G__51985;
i__51705_51963 = G__51986;
continue;
} else {
var map__51727_51987 = cljs.core.first(seq__51702_51981__$1);
var map__51727_51988__$1 = cljs.core.__destructure_map(map__51727_51987);
var i_51989 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51727_51988__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var el_51990 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51727_51988__$1,new cljs.core.Keyword(null,"el","el",-1618201118));
var component_51991 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51727_51988__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var src_51992 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51727_51988__$1,new cljs.core.Keyword(null,"src","src",-1651076051));
var args_51993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51727_51988__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_(component_51991)){
if(cljs.core.truth_(src_51992)){
var vec__51747_51994 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(src_51992,/:/);
var file_51995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51747_51994,(0),null);
var line_51996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51747_51994,(1),null);
if(cljs.core.truth_(args_51993)){
console.log(["%c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i_51989),"%c ",re_com.debug.gear_icon," %c[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(component_51991)," ...]%c in file %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file_51995),"%c at line %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_51996),"%c\n      Parameters: %O\n      DOM: %o"].join(''),re_com.debug.index_style,"",re_com.debug.code_style,"",re_com.debug.code_style,"",re_com.debug.code_style,"",args_51993,el_51990);
} else {
console.log(["%c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i_51989),"%c ",re_com.debug.gear_icon," %c[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(component_51991)," ...]%c in file %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file_51995),"%c at line %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_51996),"%c\n      DOM: %o"].join(''),re_com.debug.index_style,"",re_com.debug.code_style,"",re_com.debug.code_style,"",re_com.debug.code_style,"",el_51990);
}
} else {
console.log(["%c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i_51989),"%c ",re_com.debug.gear_icon," %c[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(component_51991)," ...]%c\n      Parameters: %O\n      DOM: %o"].join(''),re_com.debug.index_style,"",re_com.debug.code_style,"",args_51993,el_51990);
}
} else {
console.log(["%c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i_51989),"%c ",re_com.debug.globe_icon," %o"].join(''),re_com.debug.index_style,"",el_51990);
}


var G__51998 = cljs.core.next(seq__51702_51981__$1);
var G__51999 = null;
var G__52000 = (0);
var G__52001 = (0);
seq__51702_51960 = G__51998;
chunk__51703_51961 = G__51999;
count__51704_51962 = G__52000;
i__51705_51963 = G__52001;
continue;
}
} else {
}
}
break;
}

return console.groupEnd();
});
re_com.debug.log_validate_args_error_problems = (function re_com$debug$log_validate_args_error_problems(problems){
var seq__51758 = cljs.core.seq(problems);
var chunk__51759 = null;
var count__51760 = (0);
var i__51761 = (0);
while(true){
if((i__51761 < count__51760)){
var map__51781 = chunk__51759.cljs$core$IIndexed$_nth$arity$2(null,i__51761);
var map__51781__$1 = cljs.core.__destructure_map(map__51781);
var problem = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51781__$1,new cljs.core.Keyword(null,"problem","problem",1168155148));
var arg_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51781__$1,new cljs.core.Keyword(null,"arg-name","arg-name",6205923));
var expected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51781__$1,new cljs.core.Keyword(null,"expected","expected",1583670997));
var actual = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51781__$1,new cljs.core.Keyword(null,"actual","actual",107306363));
var validate_fn_result = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51781__$1,new cljs.core.Keyword(null,"validate-fn-result","validate-fn-result",280916497));
var G__51788_52002 = problem;
var G__51788_52003__$1 = (((G__51788_52002 instanceof cljs.core.Keyword))?G__51788_52002.fqn:null);
switch (G__51788_52003__$1) {
case "unknown":
console.log(["\u2022 %cUnknown parameter: %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arg_name)].join(''),re_com.debug.error_style,re_com.debug.code_style);

break;
case "required":
console.log(["\u2022 %cMissing required parameter: %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arg_name)].join(''),re_com.debug.error_style,re_com.debug.code_style);

break;
case "validate-fn":
console.log(["\u2022 %cParameter %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arg_name),"%c expected %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(expected)),"%c but got %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(actual)].join(''),re_com.debug.error_style,re_com.debug.code_style,re_com.debug.error_style,re_com.debug.code_style,re_com.debug.error_style,re_com.debug.code_style);

break;
case "validate-fn-map":
console.log(["\u2022 %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(validate_fn_result))].join(''),re_com.debug.error_style);

break;
default:
console.log("\u2022 ",re_com.debug.confused_icon," Unknown problem reported");

}


var G__52005 = seq__51758;
var G__52006 = chunk__51759;
var G__52007 = count__51760;
var G__52008 = (i__51761 + (1));
seq__51758 = G__52005;
chunk__51759 = G__52006;
count__51760 = G__52007;
i__51761 = G__52008;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__51758);
if(temp__5804__auto__){
var seq__51758__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51758__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__51758__$1);
var G__52010 = cljs.core.chunk_rest(seq__51758__$1);
var G__52011 = c__5568__auto__;
var G__52012 = cljs.core.count(c__5568__auto__);
var G__52013 = (0);
seq__51758 = G__52010;
chunk__51759 = G__52011;
count__51760 = G__52012;
i__51761 = G__52013;
continue;
} else {
var map__51797 = cljs.core.first(seq__51758__$1);
var map__51797__$1 = cljs.core.__destructure_map(map__51797);
var problem = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51797__$1,new cljs.core.Keyword(null,"problem","problem",1168155148));
var arg_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51797__$1,new cljs.core.Keyword(null,"arg-name","arg-name",6205923));
var expected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51797__$1,new cljs.core.Keyword(null,"expected","expected",1583670997));
var actual = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51797__$1,new cljs.core.Keyword(null,"actual","actual",107306363));
var validate_fn_result = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51797__$1,new cljs.core.Keyword(null,"validate-fn-result","validate-fn-result",280916497));
var G__51798_52020 = problem;
var G__51798_52021__$1 = (((G__51798_52020 instanceof cljs.core.Keyword))?G__51798_52020.fqn:null);
switch (G__51798_52021__$1) {
case "unknown":
console.log(["\u2022 %cUnknown parameter: %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arg_name)].join(''),re_com.debug.error_style,re_com.debug.code_style);

break;
case "required":
console.log(["\u2022 %cMissing required parameter: %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arg_name)].join(''),re_com.debug.error_style,re_com.debug.code_style);

break;
case "validate-fn":
console.log(["\u2022 %cParameter %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arg_name),"%c expected %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(expected)),"%c but got %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(actual)].join(''),re_com.debug.error_style,re_com.debug.code_style,re_com.debug.error_style,re_com.debug.code_style,re_com.debug.error_style,re_com.debug.code_style);

break;
case "validate-fn-map":
console.log(["\u2022 %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(validate_fn_result))].join(''),re_com.debug.error_style);

break;
default:
console.log("\u2022 ",re_com.debug.confused_icon," Unknown problem reported");

}


var G__52026 = cljs.core.next(seq__51758__$1);
var G__52027 = null;
var G__52028 = (0);
var G__52029 = (0);
seq__51758 = G__52026;
chunk__51759 = G__52027;
count__51760 = G__52028;
i__51761 = G__52029;
continue;
}
} else {
return null;
}
}
break;
}
});
re_com.debug.log_validate_args_error = (function re_com$debug$log_validate_args_error(element,problems,component_name,p__51812){
var map__51814 = p__51812;
var map__51814__$1 = cljs.core.__destructure_map(map__51814);
var src = map__51814__$1;
var file = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51814__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51814__$1,new cljs.core.Keyword(null,"line","line",212345235));
var source_url = (((!(cljs.core.empty_QMARK_(re_com.config.root_url_for_compiler_output))))?[re_com.config.root_url_for_compiler_output,cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):null);
console.group(["%c",re_com.debug.collision_icon," re-com validation error "].join(''),re_com.debug.h1_style);

if(cljs.core.truth_(src)){
if(cljs.core.truth_(source_url)){
console.log(["\u2022 ",re_com.debug.gear_icon,"%c[",re_com.debug.short_component_name(component_name)," ...]%c in file %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),"%c at line %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),"%c see ",source_url].join(''),re_com.debug.code_style,"",re_com.debug.code_style,"",re_com.debug.code_style,"");
} else {
console.log(["\u2022 ",re_com.debug.gear_icon,"%c[",re_com.debug.short_component_name(component_name)," ...]%c in file %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file),"%c at line %c",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''),re_com.debug.code_style,"",re_com.debug.code_style,"",re_com.debug.code_style);

console.log("\u2022 To enable clickable source urls, add %cre-com.config/root-url-for-compiler-output%c to your %c:closure-defines%c. See https://re-com.day8.com.au/#/config",re_com.debug.code_style,"",re_com.debug.code_style,"");
}
} else {
console.log(["\u2022 ",re_com.debug.gear_icon,"%c[",re_com.debug.short_component_name(component_name)," ...]"].join(''),re_com.debug.code_style);

console.log("\u2022 Learn how to add source coordinates to your components at https://re-com.day8.com.au/#/debug");
}

re_com.debug.log_validate_args_error_problems(problems);

re_com.debug.log_component_stack(re_com.debug.component_stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(element)));

return console.groupEnd();
});
re_com.debug.validate_args_error = (function re_com$debug$validate_args_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___52042 = arguments.length;
var i__5770__auto___52043 = (0);
while(true){
if((i__5770__auto___52043 < len__5769__auto___52042)){
args__5775__auto__.push((arguments[i__5770__auto___52043]));

var G__52044 = (i__5770__auto___52043 + (1));
i__5770__auto___52043 = G__52044;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return re_com.debug.validate_args_error.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(re_com.debug.validate_args_error.cljs$core$IFn$_invoke$arity$variadic = (function (p__51846){
var map__51847 = p__51846;
var map__51847__$1 = cljs.core.__destructure_map(map__51847);
var problems = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51847__$1,new cljs.core.Keyword(null,"problems","problems",2097327077));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51847__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51847__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var element = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var ref_fn = (function (el){
if(cljs.core.truth_(el)){
return cljs.core.reset_BANG_(element,el);
} else {
return null;
}
});
var internal_problems = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(problems);
var internal_component = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(component);
var internal_args = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(args);
return reagent.core.create_class.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display-name","display-name",694513143),"validate-args-error",new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),(function (this$){
return re_com.debug.log_validate_args_error(element,cljs.core.deref(internal_problems),cljs.core.deref(internal_component),new cljs.core.Keyword(null,"src","src",-1651076051).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(internal_args)));
}),new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),(function (this$,argv,old_state,snapshot){
return re_com.debug.log_validate_args_error(element,cljs.core.deref(internal_problems),cljs.core.deref(internal_component),new cljs.core.Keyword(null,"src","src",-1651076051).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(internal_args)));
}),new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function() { 
var G__52053__delegate = function (p__51863){
var map__51864 = p__51863;
var map__51864__$1 = cljs.core.__destructure_map(map__51864);
var problems__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51864__$1,new cljs.core.Keyword(null,"problems","problems",2097327077));
var component__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51864__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var args__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51864__$1,new cljs.core.Keyword(null,"args","args",1315556576));
cljs.core.reset_BANG_(internal_problems,problems__$1);

cljs.core.reset_BANG_(internal_component,component__$1);

cljs.core.reset_BANG_(internal_args,args__$1);

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([re_com.debug.__GT_attr(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"src","src",-1651076051),new cljs.core.Keyword(null,"src","src",-1651076051).cljs$core$IFn$_invoke$arity$1(args__$1),new cljs.core.Keyword(null,"debug-as","debug-as",283322354),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component","component",1555936782),component__$1,new cljs.core.Keyword(null,"args","args",1315556576),args__$1], null),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ref","ref",1289896967),ref_fn], null)], null)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"title","title",636505583),"re-com validation error. Look in the DevTools console.",new cljs.core.Keyword(null,"style","style",-496642736),re_com.debug.validate_args_problems_style()], null)], 0)),re_com.debug.collision_icon], null);
};
var G__52053 = function (var_args){
var p__51863 = null;
if (arguments.length > 0) {
var G__52057__i = 0, G__52057__a = new Array(arguments.length -  0);
while (G__52057__i < G__52057__a.length) {G__52057__a[G__52057__i] = arguments[G__52057__i + 0]; ++G__52057__i;}
  p__51863 = new cljs.core.IndexedSeq(G__52057__a,0,null);
} 
return G__52053__delegate.call(this,p__51863);};
G__52053.cljs$lang$maxFixedArity = 0;
G__52053.cljs$lang$applyTo = (function (arglist__52058){
var p__51863 = cljs.core.seq(arglist__52058);
return G__52053__delegate(p__51863);
});
G__52053.cljs$core$IFn$_invoke$arity$variadic = G__52053__delegate;
return G__52053;
})()
], null));
}));

(re_com.debug.validate_args_error.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(re_com.debug.validate_args_error.cljs$lang$applyTo = (function (seq51823){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq51823));
}));

re_com.debug.stack_spy = (function re_com$debug$stack_spy(var_args){
var args__5775__auto__ = [];
var len__5769__auto___52059 = arguments.length;
var i__5770__auto___52060 = (0);
while(true){
if((i__5770__auto___52060 < len__5769__auto___52059)){
args__5775__auto__.push((arguments[i__5770__auto___52060]));

var G__52064 = (i__5770__auto___52060 + (1));
i__5770__auto___52060 = G__52064;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return re_com.debug.stack_spy.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(re_com.debug.stack_spy.cljs$core$IFn$_invoke$arity$variadic = (function (p__51884){
var map__51885 = p__51884;
var map__51885__$1 = cljs.core.__destructure_map(map__51885);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51885__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var src = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51885__$1,new cljs.core.Keyword(null,"src","src",-1651076051));
var element = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var ref_fn = (function (el){
if(cljs.core.truth_(el)){
return cljs.core.reset_BANG_(element,el);
} else {
return null;
}
});
var log_fn = (function (){
var el = cljs.core.deref(element);
if(cljs.core.truth_(el)){
var first_child = cljs.core.first(el.children);
console.group("%c[stack-spy ...]",re_com.debug.code_style);

re_com.debug.log_component_stack(re_com.debug.component_stack.cljs$core$IFn$_invoke$arity$1(first_child));

return console.groupEnd();
} else {
return null;
}
});
return reagent.core.create_class.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"display-name","display-name",694513143),"stack-spy",new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),log_fn,new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),log_fn,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),(function() { 
var G__52077__delegate = function (p__51906){
var map__51907 = p__51906;
var map__51907__$1 = cljs.core.__destructure_map(map__51907);
var component__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51907__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var src__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51907__$1,new cljs.core.Keyword(null,"src","src",-1651076051));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),re_com.debug.__GT_attr(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),src__$1,new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ref","ref",1289896967),ref_fn], null)], null)),component__$1], null);
};
var G__52077 = function (var_args){
var p__51906 = null;
if (arguments.length > 0) {
var G__52081__i = 0, G__52081__a = new Array(arguments.length -  0);
while (G__52081__i < G__52081__a.length) {G__52081__a[G__52081__i] = arguments[G__52081__i + 0]; ++G__52081__i;}
  p__51906 = new cljs.core.IndexedSeq(G__52081__a,0,null);
} 
return G__52077__delegate.call(this,p__51906);};
G__52077.cljs$lang$maxFixedArity = 0;
G__52077.cljs$lang$applyTo = (function (arglist__52082){
var p__51906 = cljs.core.seq(arglist__52082);
return G__52077__delegate(p__51906);
});
G__52077.cljs$core$IFn$_invoke$arity$variadic = G__52077__delegate;
return G__52077;
})()
], null));
}));

(re_com.debug.stack_spy.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(re_com.debug.stack_spy.cljs$lang$applyTo = (function (seq51871){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq51871));
}));


//# sourceMappingURL=re_com.debug.js.map
