goog.provide('markdown.core');
markdown.core.init_transformer = (function markdown$core$init_transformer(p__28859){
var map__28860 = p__28859;
var map__28860__$1 = cljs.core.__destructure_map(map__28860);
var replacement_transformers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28860__$1,new cljs.core.Keyword(null,"replacement-transformers","replacement-transformers",-2028552897));
var custom_transformers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28860__$1,new cljs.core.Keyword(null,"custom-transformers","custom-transformers",1440601790));
var inhibit_separator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28860__$1,new cljs.core.Keyword(null,"inhibit-separator","inhibit-separator",1268116222));
return (function (html,line,next_line,state){
var _STAR_inhibit_separator_STAR__orig_val__28861 = markdown.common._STAR_inhibit_separator_STAR_;
var _STAR_inhibit_separator_STAR__temp_val__28862 = inhibit_separator;
(markdown.common._STAR_inhibit_separator_STAR_ = _STAR_inhibit_separator_STAR__temp_val__28862);

try{var vec__28863 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__28866,transformer){
var vec__28867 = p__28866;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28867,(0),null);
var state__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28867,(1),null);
var G__28870 = text;
var G__28871 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state__$1,new cljs.core.Keyword(null,"next-line","next-line",-1187000287),next_line);
return (transformer.cljs$core$IFn$_invoke$arity$2 ? transformer.cljs$core$IFn$_invoke$arity$2(G__28870,G__28871) : transformer.call(null,G__28870,G__28871));
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [line,state], null),(function (){var or__5045__auto__ = replacement_transformers;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(markdown.transformers.transformer_vector,custom_transformers);
}
})());
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28863,(0),null);
var new_state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28863,(1),null);
html.append(text);

return new_state;
}finally {(markdown.common._STAR_inhibit_separator_STAR_ = _STAR_inhibit_separator_STAR__orig_val__28861);
}});
});
/**
 * Removed from cljs.core 0.0-1885, Ref. http://goo.gl/su7Xkj
 */
markdown.core.format = (function markdown$core$format(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28915 = arguments.length;
var i__5770__auto___28916 = (0);
while(true){
if((i__5770__auto___28916 < len__5769__auto___28915)){
args__5775__auto__.push((arguments[i__5770__auto___28916]));

var G__28917 = (i__5770__auto___28916 + (1));
i__5770__auto___28916 = G__28917;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return markdown.core.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(markdown.core.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt,args);
}));

(markdown.core.format.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(markdown.core.format.cljs$lang$applyTo = (function (seq28872){
var G__28873 = cljs.core.first(seq28872);
var seq28872__$1 = cljs.core.next(seq28872);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28873,seq28872__$1);
}));

markdown.core.parse_references = (function markdown$core$parse_references(lines){
var references = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var seq__28874_28918 = cljs.core.seq(lines);
var chunk__28875_28919 = null;
var count__28876_28920 = (0);
var i__28877_28921 = (0);
while(true){
if((i__28877_28921 < count__28876_28920)){
var line_28922 = chunk__28875_28919.cljs$core$IIndexed$_nth$arity$2(null,i__28877_28921);
markdown.links.parse_reference_link(line_28922,references);


var G__28923 = seq__28874_28918;
var G__28924 = chunk__28875_28919;
var G__28925 = count__28876_28920;
var G__28926 = (i__28877_28921 + (1));
seq__28874_28918 = G__28923;
chunk__28875_28919 = G__28924;
count__28876_28920 = G__28925;
i__28877_28921 = G__28926;
continue;
} else {
var temp__5804__auto___28927 = cljs.core.seq(seq__28874_28918);
if(temp__5804__auto___28927){
var seq__28874_28928__$1 = temp__5804__auto___28927;
if(cljs.core.chunked_seq_QMARK_(seq__28874_28928__$1)){
var c__5568__auto___28929 = cljs.core.chunk_first(seq__28874_28928__$1);
var G__28930 = cljs.core.chunk_rest(seq__28874_28928__$1);
var G__28931 = c__5568__auto___28929;
var G__28932 = cljs.core.count(c__5568__auto___28929);
var G__28933 = (0);
seq__28874_28918 = G__28930;
chunk__28875_28919 = G__28931;
count__28876_28920 = G__28932;
i__28877_28921 = G__28933;
continue;
} else {
var line_28934 = cljs.core.first(seq__28874_28928__$1);
markdown.links.parse_reference_link(line_28934,references);


var G__28935 = cljs.core.next(seq__28874_28928__$1);
var G__28936 = null;
var G__28937 = (0);
var G__28938 = (0);
seq__28874_28918 = G__28935;
chunk__28875_28919 = G__28936;
count__28876_28920 = G__28937;
i__28877_28921 = G__28938;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(references);
});
markdown.core.parse_footnotes = (function markdown$core$parse_footnotes(lines){
var footnotes = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"next-fn-id","next-fn-id",738579636),(1),new cljs.core.Keyword(null,"processed","processed",800622264),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"unprocessed","unprocessed",766771972),cljs.core.PersistentArrayMap.EMPTY], null));
var seq__28881_28939 = cljs.core.seq(lines);
var chunk__28882_28940 = null;
var count__28883_28941 = (0);
var i__28884_28942 = (0);
while(true){
if((i__28884_28942 < count__28883_28941)){
var line_28943 = chunk__28882_28940.cljs$core$IIndexed$_nth$arity$2(null,i__28884_28942);
markdown.links.parse_footnote_link(line_28943,footnotes);


var G__28944 = seq__28881_28939;
var G__28945 = chunk__28882_28940;
var G__28946 = count__28883_28941;
var G__28947 = (i__28884_28942 + (1));
seq__28881_28939 = G__28944;
chunk__28882_28940 = G__28945;
count__28883_28941 = G__28946;
i__28884_28942 = G__28947;
continue;
} else {
var temp__5804__auto___28948 = cljs.core.seq(seq__28881_28939);
if(temp__5804__auto___28948){
var seq__28881_28949__$1 = temp__5804__auto___28948;
if(cljs.core.chunked_seq_QMARK_(seq__28881_28949__$1)){
var c__5568__auto___28950 = cljs.core.chunk_first(seq__28881_28949__$1);
var G__28951 = cljs.core.chunk_rest(seq__28881_28949__$1);
var G__28952 = c__5568__auto___28950;
var G__28953 = cljs.core.count(c__5568__auto___28950);
var G__28954 = (0);
seq__28881_28939 = G__28951;
chunk__28882_28940 = G__28952;
count__28883_28941 = G__28953;
i__28884_28942 = G__28954;
continue;
} else {
var line_28955 = cljs.core.first(seq__28881_28949__$1);
markdown.links.parse_footnote_link(line_28955,footnotes);


var G__28956 = cljs.core.next(seq__28881_28949__$1);
var G__28957 = null;
var G__28958 = (0);
var G__28959 = (0);
seq__28881_28939 = G__28956;
chunk__28882_28940 = G__28957;
count__28883_28941 = G__28958;
i__28884_28942 = G__28959;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(footnotes);
});
markdown.core.parse_metadata = (function markdown$core$parse_metadata(lines){
var vec__28886 = cljs.core.split_with((function (p1__28885_SHARP_){
return cljs.core.not_empty(p1__28885_SHARP_.trim());
}),lines);
var metadata = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28886,(0),null);
var lines__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28886,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [markdown.transformers.parse_metadata_headers(metadata),lines__$1], null);
});
/**
 * processes input text line by line and outputs an HTML string
 */
markdown.core.md_to_html_string_STAR_ = (function markdown$core$md_to_html_string_STAR_(text,params){
var _STAR_substring_STAR__orig_val__28889 = markdown.common._STAR_substring_STAR_;
var _STAR_formatter_STAR__orig_val__28890 = markdown.transformers._STAR_formatter_STAR_;
var _STAR_substring_STAR__temp_val__28891 = (function (s,n){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});
var _STAR_formatter_STAR__temp_val__28892 = markdown.core.format;
(markdown.common._STAR_substring_STAR_ = _STAR_substring_STAR__temp_val__28891);

(markdown.transformers._STAR_formatter_STAR_ = _STAR_formatter_STAR__temp_val__28892);

try{var params__$1 = (cljs.core.truth_(params)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc,cljs.core.PersistentArrayMap.EMPTY),params):null);
var lines = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),"\n"].join('').split("\n");
var html = (new goog.string.StringBuffer(""));
var references = (cljs.core.truth_(new cljs.core.Keyword(null,"reference-links?","reference-links?",-2003778981).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_references(lines):null);
var footnotes = (cljs.core.truth_(new cljs.core.Keyword(null,"footnotes?","footnotes?",-1590157845).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_footnotes(lines):null);
var vec__28893 = (cljs.core.truth_(new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742).cljs$core$IFn$_invoke$arity$1(params__$1))?markdown.core.parse_metadata(lines):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,lines], null));
var metadata = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28893,(0),null);
var lines__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28893,(1),null);
var transformer = markdown.core.init_transformer(params__$1);
var G__28899_28960 = lines__$1;
var vec__28900_28961 = G__28899_28960;
var seq__28901_28962 = cljs.core.seq(vec__28900_28961);
var first__28902_28963 = cljs.core.first(seq__28901_28962);
var seq__28901_28964__$1 = cljs.core.next(seq__28901_28962);
var line_28965 = first__28902_28963;
var more_28966 = seq__28901_28964__$1;
var state_28967 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"clojurescript","clojurescript",-299769403),true,new cljs.core.Keyword(null,"references","references",882562509),references,new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205),footnotes,new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true], null),params__$1], 0));
var G__28899_28969__$1 = G__28899_28960;
var state_28970__$1 = state_28967;
while(true){
var vec__28906_28971 = G__28899_28969__$1;
var seq__28907_28972 = cljs.core.seq(vec__28906_28971);
var first__28908_28973 = cljs.core.first(seq__28907_28972);
var seq__28907_28974__$1 = cljs.core.next(seq__28907_28972);
var line_28975__$1 = first__28908_28973;
var more_28976__$1 = seq__28907_28974__$1;
var state_28977__$2 = state_28970__$1;
var line_28978__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749).cljs$core$IFn$_invoke$arity$1(state_28977__$2))?"":line_28975__$1);
var state_28979__$3 = (cljs.core.truth_(new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_28977__$2))?transformer(html,new cljs.core.Keyword(null,"buf","buf",-213913340).cljs$core$IFn$_invoke$arity$1(state_28977__$2),new cljs.core.Keyword(null,"next-line","next-line",-1187000287).cljs$core$IFn$_invoke$arity$1(state_28977__$2),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(state_28977__$2,new cljs.core.Keyword(null,"buf","buf",-213913340),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"lists","lists",-884730684),new cljs.core.Keyword(null,"next-line","next-line",-1187000287)], 0)),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),true)):state_28977__$2);
if(cljs.core.truth_(cljs.core.not_empty(more_28976__$1))){
var G__28980 = more_28976__$1;
var G__28981 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(transformer(html,line_28978__$2,cljs.core.first(more_28976__$1),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(state_28979__$3,new cljs.core.Keyword(null,"skip-next-line?","skip-next-line?",1683617749))),new cljs.core.Keyword(null,"last-line-empty?","last-line-empty?",1279111527),cljs.core.empty_QMARK_(line_28978__$2.trim()));
G__28899_28969__$1 = G__28980;
state_28970__$1 = G__28981;
continue;
} else {
transformer(html.append(markdown.transformers.footer(new cljs.core.Keyword(null,"footnotes","footnotes",-1842778205).cljs$core$IFn$_invoke$arity$1(state_28979__$3))),line_28978__$2,"",cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state_28979__$3,new cljs.core.Keyword(null,"eof","eof",-489063237),true));
}
break;
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"metadata","metadata",1799301597),metadata,new cljs.core.Keyword(null,"html","html",-998796897),html.toString()], null);
}finally {(markdown.transformers._STAR_formatter_STAR_ = _STAR_formatter_STAR__orig_val__28890);

(markdown.common._STAR_substring_STAR_ = _STAR_substring_STAR__orig_val__28889);
}});
markdown.core.md__GT_html = (function markdown$core$md__GT_html(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28982 = arguments.length;
var i__5770__auto___28983 = (0);
while(true){
if((i__5770__auto___28983 < len__5769__auto___28982)){
args__5775__auto__.push((arguments[i__5770__auto___28983]));

var G__28984 = (i__5770__auto___28983 + (1));
i__5770__auto___28983 = G__28984;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(markdown.core.md__GT_html.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return new cljs.core.Keyword(null,"html","html",-998796897).cljs$core$IFn$_invoke$arity$1(markdown.core.md_to_html_string_STAR_(text,params));
}));

(markdown.core.md__GT_html.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(markdown.core.md__GT_html.cljs$lang$applyTo = (function (seq28909){
var G__28910 = cljs.core.first(seq28909);
var seq28909__$1 = cljs.core.next(seq28909);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28910,seq28909__$1);
}));

markdown.core.md__GT_html_with_meta = (function markdown$core$md__GT_html_with_meta(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28985 = arguments.length;
var i__5770__auto___28986 = (0);
while(true){
if((i__5770__auto___28986 < len__5769__auto___28985)){
args__5775__auto__.push((arguments[i__5770__auto___28986]));

var G__28987 = (i__5770__auto___28986 + (1));
i__5770__auto___28986 = G__28987;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(markdown.core.md__GT_html_with_meta.cljs$core$IFn$_invoke$arity$variadic = (function (text,params){
return markdown.core.md_to_html_string_STAR_(text,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parse-meta?","parse-meta?",-1938948742),true], null),params));
}));

(markdown.core.md__GT_html_with_meta.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(markdown.core.md__GT_html_with_meta.cljs$lang$applyTo = (function (seq28911){
var G__28912 = cljs.core.first(seq28911);
var seq28911__$1 = cljs.core.next(seq28911);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28912,seq28911__$1);
}));

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtml = (function markdown$core$mdToHtml(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28988 = arguments.length;
var i__5770__auto___28989 = (0);
while(true){
if((i__5770__auto___28989 < len__5769__auto___28988)){
args__5775__auto__.push((arguments[i__5770__auto___28989]));

var G__28990 = (i__5770__auto___28989 + (1));
i__5770__auto___28989 = G__28990;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});
goog.exportSymbol('markdown.core.mdToHtml', markdown.core.mdToHtml);

(markdown.core.mdToHtml.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(markdown.core.md__GT_html,params);
}));

(markdown.core.mdToHtml.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(markdown.core.mdToHtml.cljs$lang$applyTo = (function (seq28913){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28913));
}));

/**
 * Js accessible wrapper
 */
markdown.core.mdToHtmlWithMeta = (function markdown$core$mdToHtmlWithMeta(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28991 = arguments.length;
var i__5770__auto___28992 = (0);
while(true){
if((i__5770__auto___28992 < len__5769__auto___28991)){
args__5775__auto__.push((arguments[i__5770__auto___28992]));

var G__28993 = (i__5770__auto___28992 + (1));
i__5770__auto___28992 = G__28993;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});
goog.exportSymbol('markdown.core.mdToHtmlWithMeta', markdown.core.mdToHtmlWithMeta);

(markdown.core.mdToHtmlWithMeta.cljs$core$IFn$_invoke$arity$variadic = (function (params){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(markdown.core.md__GT_html_with_meta,params);
}));

(markdown.core.mdToHtmlWithMeta.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(markdown.core.mdToHtmlWithMeta.cljs$lang$applyTo = (function (seq28914){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28914));
}));


//# sourceMappingURL=markdown.core.js.map
