goog.provide('haslett.client');
/**
 * Close a stream opened by connect.
 */
haslett.client.close = (function haslett$client$close(stream){
new cljs.core.Keyword(null,"socket","socket",59137063).cljs$core$IFn$_invoke$arity$1(stream).close((1000),"Closed by creator");

return new cljs.core.Keyword(null,"close-status","close-status",-239776180).cljs$core$IFn$_invoke$arity$1(stream);
});
/**
 * Create a WebSocket to the specified URL, and returns a 'stream' map of four
 *   keys:
 * 
 *  :socket       - contains the WebSocket object
 *  :close-status - a promise channel that contains the final close status
 *  :source       - a core.async channel to read from
 *  :sink         - a core.async channel to write to
 * 
 *   Takes the following options:
 * 
 *  :format      - a formatter from haslett.format
 *  :source      - a custom channel to use as the source
 *  :sink        - a custom channel to use as the sink
 *  :protocols   - passed to the WebSocket, a vector of protocol strings
 *  :binary-type - passed to the WebSocket, may be :blob or :arraybuffer
 *  :close-chan? - true if channels should be closed if WebSocket is closed
 *                 (defaults to true)
 * 
 *   The WebSocket may either be closed directly, or by closing the
 *   stream's :sink channel.
 */
haslett.client.connect = (function haslett$client$connect(var_args){
var G__57422 = arguments.length;
switch (G__57422) {
case 1:
return haslett.client.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return haslett.client.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(haslett.client.connect.cljs$core$IFn$_invoke$arity$1 = (function (url){
return haslett.client.connect.cljs$core$IFn$_invoke$arity$2(url,cljs.core.PersistentArrayMap.EMPTY);
}));

(haslett.client.connect.cljs$core$IFn$_invoke$arity$2 = (function (url,options){
var protocols = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$2(options,cljs.core.PersistentVector.EMPTY));
var socket = (new WebSocket(url,protocols));
var source = new cljs.core.Keyword(null,"source","source",-433931539).cljs$core$IFn$_invoke$arity$2(options,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var sink = new cljs.core.Keyword(null,"sink","sink",186835933).cljs$core$IFn$_invoke$arity$2(options,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var format = new cljs.core.Keyword(null,"format","format",-1306924766).cljs$core$IFn$_invoke$arity$2(options,haslett.format.identity);
var status = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var return$ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var close_QMARK_ = new cljs.core.Keyword(null,"close-chan?","close-chan?",-1940681973).cljs$core$IFn$_invoke$arity$2(options,true);
var stream = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"socket","socket",59137063),socket,new cljs.core.Keyword(null,"source","source",-433931539),source,new cljs.core.Keyword(null,"sink","sink",186835933),sink,new cljs.core.Keyword(null,"close-status","close-status",-239776180),status], null);
(socket.binaryType = cljs.core.name(new cljs.core.Keyword(null,"binary-type","binary-type",1096940609).cljs$core$IFn$_invoke$arity$2(options,new cljs.core.Keyword(null,"arraybuffer","arraybuffer",1394959763))));

(socket.onopen = (function (_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return$,stream);
}));

(socket.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(source,haslett.format.read(format,e.data));
}));

(socket.onclose = (function (e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(status,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),e.reason,new cljs.core.Keyword(null,"code","code",1586293142),e.code], null));

if(cljs.core.truth_(close_QMARK_)){
cljs.core.async.close_BANG_(source);
} else {
}

if(cljs.core.truth_(close_QMARK_)){
cljs.core.async.close_BANG_(sink);
} else {
}

return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return$,stream);
}));

var c__44773__auto___57483 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44774__auto__ = (function (){var switch__44576__auto__ = (function (state_57449){
var state_val_57450 = (state_57449[(1)]);
if((state_val_57450 === (1))){
var state_57449__$1 = state_57449;
var statearr_57451_57485 = state_57449__$1;
(statearr_57451_57485[(2)] = null);

(statearr_57451_57485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (2))){
var state_57449__$1 = state_57449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57449__$1,(4),sink);
} else {
if((state_val_57450 === (3))){
var inst_57447 = (state_57449[(2)]);
var state_57449__$1 = state_57449;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57449__$1,inst_57447);
} else {
if((state_val_57450 === (4))){
var inst_57436 = (state_57449[(7)]);
var inst_57436__$1 = (state_57449[(2)]);
var state_57449__$1 = (function (){var statearr_57453 = state_57449;
(statearr_57453[(7)] = inst_57436__$1);

return statearr_57453;
})();
if(cljs.core.truth_(inst_57436__$1)){
var statearr_57454_57486 = state_57449__$1;
(statearr_57454_57486[(1)] = (5));

} else {
var statearr_57455_57487 = state_57449__$1;
(statearr_57455_57487[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (5))){
var inst_57436 = (state_57449[(7)]);
var inst_57439 = haslett.format.write(format,inst_57436);
var inst_57440 = socket.send(inst_57439);
var state_57449__$1 = (function (){var statearr_57456 = state_57449;
(statearr_57456[(8)] = inst_57440);

return statearr_57456;
})();
var statearr_57457_57489 = state_57449__$1;
(statearr_57457_57489[(2)] = null);

(statearr_57457_57489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (6))){
var state_57449__$1 = state_57449;
var statearr_57458_57491 = state_57449__$1;
(statearr_57458_57491[(2)] = null);

(statearr_57458_57491[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (7))){
var inst_57444 = (state_57449[(2)]);
var inst_57445 = haslett.client.close(stream);
var state_57449__$1 = (function (){var statearr_57459 = state_57449;
(statearr_57459[(9)] = inst_57444);

return statearr_57459;
})();
var statearr_57460_57492 = state_57449__$1;
(statearr_57460_57492[(2)] = inst_57445);

(statearr_57460_57492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var haslett$client$state_machine__44577__auto__ = null;
var haslett$client$state_machine__44577__auto____0 = (function (){
var statearr_57465 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57465[(0)] = haslett$client$state_machine__44577__auto__);

(statearr_57465[(1)] = (1));

return statearr_57465;
});
var haslett$client$state_machine__44577__auto____1 = (function (state_57449){
while(true){
var ret_value__44578__auto__ = (function (){try{while(true){
var result__44579__auto__ = switch__44576__auto__(state_57449);
if(cljs.core.keyword_identical_QMARK_(result__44579__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44579__auto__;
}
break;
}
}catch (e57468){var ex__44580__auto__ = e57468;
var statearr_57475_57493 = state_57449;
(statearr_57475_57493[(2)] = ex__44580__auto__);


if(cljs.core.seq((state_57449[(4)]))){
var statearr_57476_57494 = state_57449;
(statearr_57476_57494[(1)] = cljs.core.first((state_57449[(4)])));

} else {
throw ex__44580__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44578__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57495 = state_57449;
state_57449 = G__57495;
continue;
} else {
return ret_value__44578__auto__;
}
break;
}
});
haslett$client$state_machine__44577__auto__ = function(state_57449){
switch(arguments.length){
case 0:
return haslett$client$state_machine__44577__auto____0.call(this);
case 1:
return haslett$client$state_machine__44577__auto____1.call(this,state_57449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
haslett$client$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$0 = haslett$client$state_machine__44577__auto____0;
haslett$client$state_machine__44577__auto__.cljs$core$IFn$_invoke$arity$1 = haslett$client$state_machine__44577__auto____1;
return haslett$client$state_machine__44577__auto__;
})()
})();
var state__44775__auto__ = (function (){var statearr_57477 = f__44774__auto__();
(statearr_57477[(6)] = c__44773__auto___57483);

return statearr_57477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44775__auto__);
}));


return return$;
}));

(haslett.client.connect.cljs$lang$maxFixedArity = 2);

/**
 * Return true if the stream is currently connected.
 */
haslett.client.connected_QMARK_ = (function haslett$client$connected_QMARK_(p__57478){
var map__57479 = p__57478;
var map__57479__$1 = cljs.core.__destructure_map(map__57479);
var close_status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57479__$1,new cljs.core.Keyword(null,"close-status","close-status",-239776180));
return (cljs.core.async.poll_BANG_(close_status) == null);
});

//# sourceMappingURL=haslett.client.js.map
