goog.provide('com.wsscode.edn_json');
goog.scope(function(){
  com.wsscode.edn_json.goog$module$goog$object = goog.module.get('goog.object');
});
cljs.spec.alpha.def_impl(new cljs.core.Keyword("com.wsscode.edn-json","encode-list-type?","com.wsscode.edn-json/encode-list-type?",948255483),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
cljs.spec.alpha.def_impl(new cljs.core.Keyword("com.wsscode.edn-json","encode-value","com.wsscode.edn-json/encode-value",1092543804),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null),"null"], null), null))))),cljs.spec.alpha.with_gen(cljs.spec.alpha.nilable_impl(cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.fspec_impl(cljs.spec.alpha.spec_impl.cljs$core$IFn$_invoke$arity$4(cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.cat_impl(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.any_QMARK_], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.spec_impl.cljs$core$IFn$_invoke$arity$4(new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null),null),(function (){
return cljs.spec.alpha.gen.cljs$core$IFn$_invoke$arity$1(cljs.spec.alpha.nilable_impl(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"str","str",-1564826950,null),"null"], null), null),cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.str]),null));
})));
cljs.spec.alpha.def_impl(new cljs.core.Keyword("com.wsscode.edn-json","encode-map-key","com.wsscode.edn-json/encode-map-key",1454660584),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","with-gen","cljs.spec.alpha/with-gen",1999495028,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),cljs.core.PersistentVector.EMPTY,cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","gen","cljs.spec.alpha/gen",147877780,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","nilable","cljs.spec.alpha/nilable",1628308748,null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol("cljs.core","str","cljs.core/str",-1971828991,null),"null"], null), null))))),cljs.spec.alpha.with_gen(cljs.spec.alpha.nilable_impl(cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","fspec","cljs.spec.alpha/fspec",-1289128341,null),new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.fspec_impl(cljs.spec.alpha.spec_impl.cljs$core$IFn$_invoke$arity$4(cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.cat_impl(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.any_QMARK_], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)], null)),null,null),cljs.core.list(new cljs.core.Symbol("cljs.spec.alpha","cat","cljs.spec.alpha/cat",-1471398329,null),new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null)),cljs.spec.alpha.spec_impl.cljs$core$IFn$_invoke$arity$4(new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),cljs.core.any_QMARK_,null,null),new cljs.core.Symbol("cljs.core","any?","cljs.core/any?",-2068111842,null),null,null,null),null),(function (){
return cljs.spec.alpha.gen.cljs$core$IFn$_invoke$arity$1(cljs.spec.alpha.nilable_impl(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"str","str",-1564826950,null),"null"], null), null),cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.str]),null));
})));
cljs.spec.alpha.def_impl(new cljs.core.Keyword("com.wsscode.edn-json","decode-edn-values?","com.wsscode.edn-json/decode-edn-values?",129333438),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
/**
 * Return true for simple JS types. The intended use of this function is to detect if
 *   a value should be stored in its original form, for values that return false here, its
 *   expected that they get some encoding process before ending up as a JS value.
 */
com.wsscode.edn_json.simple_js_type_QMARK_ = (function com$wsscode$edn_json$simple_js_type_QMARK_(x){
return ((typeof x === 'string') || (((typeof x === 'number') || (((cljs.core.boolean_QMARK_(x)) || ((((x == null)) || ((void 0 === x)))))))));
});
/**
 * Encode map key, keywords numbers and strings are always encoded as strings. By
 *   default encode other keys using the prefix `__edn-key|` and the END encoded value.
 * 
 *   If you provide ::encode-map-key, this will be used instead of the default encode.
 */
com.wsscode.edn_json.encode_key = (function com$wsscode$edn_json$encode_key(x,p__57046){
var map__57047 = p__57046;
var map__57047__$1 = cljs.core.__destructure_map(map__57047);
var encode_map_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57047__$1,new cljs.core.Keyword("com.wsscode.edn-json","encode-map-key","com.wsscode.edn-json/encode-map-key",1454660584));
if((((x instanceof cljs.core.Keyword)) || (((typeof x === 'number') || (typeof x === 'string'))))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
} else {
if(cljs.core.truth_(encode_map_key)){
return (encode_map_key.cljs$core$IFn$_invoke$arity$1 ? encode_map_key.cljs$core$IFn$_invoke$arity$1(x) : encode_map_key.call(null,x));
} else {
return ["__edn-key|",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0))].join('');
}

}
});
/**
 * Decode string key to EDN, if key is not a string it is returned as is.
 */
com.wsscode.edn_json.decode_key = (function com$wsscode$edn_json$decode_key(s){
if(typeof s === 'string'){
if(clojure.string.starts_with_QMARK_(s,":")){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(1)));
} else {
if(clojure.string.starts_with_QMARK_(s,"__edn-key|")){
return clojure.edn.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(("__edn-key|").length)));
} else {
return s;

}
}
} else {
return s;
}
});
/**
 * Encode value representation, can be overwritten with the ::encode-value setting.
 */
com.wsscode.edn_json.encode_value = (function com$wsscode$edn_json$encode_value(x,p__57056){
var map__57057 = p__57056;
var map__57057__$1 = cljs.core.__destructure_map(map__57057);
var encode_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57057__$1,new cljs.core.Keyword("com.wsscode.edn-json","encode-value","com.wsscode.edn-json/encode-value",1092543804));
if(cljs.core.truth_(encode_value)){
return (encode_value.cljs$core$IFn$_invoke$arity$1 ? encode_value.cljs$core$IFn$_invoke$arity$1(x) : encode_value.call(null,x));
} else {
return ["__edn-value|",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0))].join('');
}
});
com.wsscode.edn_json.edn_value_str_QMARK_ = (function com$wsscode$edn_json$edn_value_str_QMARK_(x){
return ((typeof x === 'string') && (clojure.string.starts_with_QMARK_(x,"__edn-value|")));
});
com.wsscode.edn_json.decode_value = (function com$wsscode$edn_json$decode_value(x,p__57059){
var map__57060 = p__57059;
var map__57060__$1 = cljs.core.__destructure_map(map__57060);
var decode_edn_values_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__57060__$1,new cljs.core.Keyword("com.wsscode.edn-json","decode-edn-values?","com.wsscode.edn-json/decode-edn-values?",129333438),true);
if(cljs.core.truth_((function (){var and__5043__auto__ = decode_edn_values_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return com.wsscode.edn_json.edn_value_str_QMARK_(x);
} else {
return and__5043__auto__;
}
})())){
return clojure.edn.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(x,(("__edn-value|").length)));
} else {
return x;
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * 
 *   The encoded JSON will have extra notation to enable a better deserialization
 *   later, keeping complex keys, keyword keys (simple and qualified), also encode
 *   extended types like UUID and dates. Using json->edn you can restore the original
 *   data from the JSON.
 * 
 *   Some things that don't get restored:
 * 
 *   - metadata is lost
 *   - number keys on maps will be turned into strings on the conversion back
 * 
 *   Other than that, all printable values should encode and decode with fidelity.
 */
com.wsscode.edn_json.edn__GT_json = (function com$wsscode$edn_json$edn__GT_json(var_args){
var G__57071 = arguments.length;
switch (G__57071) {
case 1:
return com.wsscode.edn_json.edn__GT_json.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_json.edn__GT_json.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_json.edn__GT_json.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_json.edn__GT_json.cljs$core$IFn$_invoke$arity$2(x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_json.edn__GT_json.cljs$core$IFn$_invoke$arity$2 = (function (x,p__57074){
var map__57075 = p__57074;
var map__57075__$1 = cljs.core.__destructure_map(map__57075);
var opts = map__57075__$1;
var encode_list_type_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__57075__$1,new cljs.core.Keyword("com.wsscode.edn-json","encode-list-type?","com.wsscode.edn-json/encode-list-type?",948255483),true);
var thisfn = (function com$wsscode$edn_json$thisfn(x__$1){
if(((typeof x__$1 === 'string') && (clojure.string.starts_with_QMARK_(x__$1,"__edn-value|")))){
return com.wsscode.edn_json.encode_value(x__$1,opts);
} else {
if(com.wsscode.edn_json.simple_js_type_QMARK_(x__$1)){
return x__$1;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__57131_57330 = cljs.core.seq(x__$1);
var chunk__57132_57331 = null;
var count__57133_57332 = (0);
var i__57134_57333 = (0);
while(true){
if((i__57134_57333 < count__57133_57332)){
var vec__57148_57334 = chunk__57132_57331.cljs$core$IIndexed$_nth$arity$2(null,i__57134_57333);
var k_57335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57148_57334,(0),null);
var v_57336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57148_57334,(1),null);
com.wsscode.edn_json.goog$module$goog$object.set(m,com.wsscode.edn_json.encode_key(k_57335,opts),com$wsscode$edn_json$thisfn(v_57336));


var G__57337 = seq__57131_57330;
var G__57338 = chunk__57132_57331;
var G__57339 = count__57133_57332;
var G__57340 = (i__57134_57333 + (1));
seq__57131_57330 = G__57337;
chunk__57132_57331 = G__57338;
count__57133_57332 = G__57339;
i__57134_57333 = G__57340;
continue;
} else {
var temp__5804__auto___57342 = cljs.core.seq(seq__57131_57330);
if(temp__5804__auto___57342){
var seq__57131_57343__$1 = temp__5804__auto___57342;
if(cljs.core.chunked_seq_QMARK_(seq__57131_57343__$1)){
var c__5568__auto___57344 = cljs.core.chunk_first(seq__57131_57343__$1);
var G__57345 = cljs.core.chunk_rest(seq__57131_57343__$1);
var G__57346 = c__5568__auto___57344;
var G__57347 = cljs.core.count(c__5568__auto___57344);
var G__57348 = (0);
seq__57131_57330 = G__57345;
chunk__57132_57331 = G__57346;
count__57133_57332 = G__57347;
i__57134_57333 = G__57348;
continue;
} else {
var vec__57153_57349 = cljs.core.first(seq__57131_57343__$1);
var k_57350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57153_57349,(0),null);
var v_57351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57153_57349,(1),null);
com.wsscode.edn_json.goog$module$goog$object.set(m,com.wsscode.edn_json.encode_key(k_57350,opts),com$wsscode$edn_json$thisfn(v_57351));


var G__57357 = cljs.core.next(seq__57131_57343__$1);
var G__57358 = null;
var G__57359 = (0);
var G__57360 = (0);
seq__57131_57330 = G__57357;
chunk__57132_57331 = G__57358;
count__57133_57332 = G__57359;
i__57134_57333 = G__57360;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
if(cljs.core.truth_(encode_list_type_QMARK_)){
if(cljs.core.set_QMARK_(x__$1)){
arr.push("__edn-list-type|set");
} else {
if(cljs.core.list_QMARK_(x__$1)){
arr.push("__edn-list-type|list");
} else {
}
}
} else {
}

var seq__57165_57361 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(com$wsscode$edn_json$thisfn,x__$1));
var chunk__57166_57362 = null;
var count__57167_57363 = (0);
var i__57168_57364 = (0);
while(true){
if((i__57168_57364 < count__57167_57363)){
var x_57365__$2 = chunk__57166_57362.cljs$core$IIndexed$_nth$arity$2(null,i__57168_57364);
arr.push(x_57365__$2);


var G__57366 = seq__57165_57361;
var G__57367 = chunk__57166_57362;
var G__57368 = count__57167_57363;
var G__57369 = (i__57168_57364 + (1));
seq__57165_57361 = G__57366;
chunk__57166_57362 = G__57367;
count__57167_57363 = G__57368;
i__57168_57364 = G__57369;
continue;
} else {
var temp__5804__auto___57373 = cljs.core.seq(seq__57165_57361);
if(temp__5804__auto___57373){
var seq__57165_57374__$1 = temp__5804__auto___57373;
if(cljs.core.chunked_seq_QMARK_(seq__57165_57374__$1)){
var c__5568__auto___57375 = cljs.core.chunk_first(seq__57165_57374__$1);
var G__57376 = cljs.core.chunk_rest(seq__57165_57374__$1);
var G__57377 = c__5568__auto___57375;
var G__57378 = cljs.core.count(c__5568__auto___57375);
var G__57379 = (0);
seq__57165_57361 = G__57376;
chunk__57166_57362 = G__57377;
count__57167_57363 = G__57378;
i__57168_57364 = G__57379;
continue;
} else {
var x_57380__$2 = cljs.core.first(seq__57165_57374__$1);
arr.push(x_57380__$2);


var G__57382 = cljs.core.next(seq__57165_57374__$1);
var G__57383 = null;
var G__57384 = (0);
var G__57385 = (0);
seq__57165_57361 = G__57382;
chunk__57166_57362 = G__57383;
count__57167_57363 = G__57384;
i__57168_57364 = G__57385;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return com.wsscode.edn_json.encode_value(x__$1,opts);

}
}
}
}
}
});
return thisfn(x);
}));

(com.wsscode.edn_json.edn__GT_json.cljs$lang$maxFixedArity = 2);

/**
 * Same as edn->json, but returns Clojure maps that are JSON friendly instead of the
 *   JSON directly. This is useful as a middle format if you need to later send it encoded
 *   as JSON.
 */
com.wsscode.edn_json.edn__GT_json_like = (function com$wsscode$edn_json$edn__GT_json_like(var_args){
var G__57177 = arguments.length;
switch (G__57177) {
case 1:
return com.wsscode.edn_json.edn__GT_json_like.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_json.edn__GT_json_like.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_json.edn__GT_json_like.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_json.edn__GT_json_like.cljs$core$IFn$_invoke$arity$2(x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_json.edn__GT_json_like.cljs$core$IFn$_invoke$arity$2 = (function (x,p__57179){
var map__57180 = p__57179;
var map__57180__$1 = cljs.core.__destructure_map(map__57180);
var opts = map__57180__$1;
var encode_list_type_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__57180__$1,new cljs.core.Keyword("com.wsscode.edn-json","encode-list-type?","com.wsscode.edn-json/encode-list-type?",948255483),true);
var thisfn = (function com$wsscode$edn_json$thisfn(x__$1){
if(((typeof x__$1 === 'string') && (clojure.string.starts_with_QMARK_(x__$1,"__edn-value|")))){
return com.wsscode.edn_json.encode_value(x__$1,opts);
} else {
if(com.wsscode.edn_json.simple_js_type_QMARK_(x__$1)){
return x__$1;
} else {
if(cljs.core.map_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p__57193){
var vec__57194 = p__57193;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57194,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__57194,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.wsscode.edn_json.encode_key(k,opts),com$wsscode$edn_json$thisfn(v)], null);
})),x__$1);
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = (cljs.core.truth_(encode_list_type_QMARK_)?(function (){var G__57199 = cljs.core.PersistentVector.EMPTY;
var G__57199__$1 = ((cljs.core.set_QMARK_(x__$1))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__57199,"__edn-list-type|set"):G__57199);
if(cljs.core.list_QMARK_(x__$1)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__57199__$1,"__edn-list-type|list");
} else {
return G__57199__$1;
}
})():cljs.core.PersistentVector.EMPTY);
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arr,cljs.core.map.cljs$core$IFn$_invoke$arity$1(com$wsscode$edn_json$thisfn),x__$1);
} else {
return com.wsscode.edn_json.encode_value(x__$1,opts);

}
}
}
}
});
return thisfn(x);
}));

(com.wsscode.edn_json.edn__GT_json_like.cljs$lang$maxFixedArity = 2);

com.wsscode.edn_json.js_obj_QMARK_ = (function com$wsscode$edn_json$js_obj_QMARK_(x){
return (cljs.core.type(x) === Object);
});
com.wsscode.edn_json.list_type_STAR_ = (function com$wsscode$edn_json$list_type_STAR_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
var and__5043__auto____$1 = clojure.string.starts_with_QMARK_(x,"__edn-list-type|");
if(and__5043__auto____$1){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(x,(("__edn-list-type|").length));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
com.wsscode.edn_json.list_type = (function com$wsscode$edn_json$list_type(x){
var f = (x[(0)]);
return com.wsscode.edn_json.list_type_STAR_(f);
});
/**
 * Recursively transforms JavaScript arrays into ClojureScript
 *   vectors, and JavaScript objects into ClojureScript maps.
 * 
 *   Use to get fidelity restore of JSON data encoded with edn->json.
 */
com.wsscode.edn_json.json__GT_edn = (function com$wsscode$edn_json$json__GT_edn(var_args){
var G__57217 = arguments.length;
switch (G__57217) {
case 1:
return com.wsscode.edn_json.json__GT_edn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_json.json__GT_edn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_json.json__GT_edn.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_json.json__GT_edn.cljs$core$IFn$_invoke$arity$2(x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_json.json__GT_edn.cljs$core$IFn$_invoke$arity$2 = (function (x,opts){
var f = (function com$wsscode$edn_json$thisfn(x__$1){
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeClojure$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,x__$1))){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(com$wsscode$edn_json$thisfn,x__$1));
} else {
if(cljs.core.map_entry_QMARK_(x__$1)){
return (new cljs.core.MapEntry(com$wsscode$edn_json$thisfn(cljs.core.key(x__$1)),com$wsscode$edn_json$thisfn(cljs.core.val(x__$1)),null));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$1(com$wsscode$edn_json$thisfn),x__$1);
} else {
if(cljs.core.array_QMARK_(x__$1)){
var lt = com.wsscode.edn_json.list_type(x__$1);
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((function (){var G__57222 = lt;
switch (G__57222) {
case "list":
return cljs.core.List.EMPTY;

break;
case "set":
return cljs.core.PersistentHashSet.EMPTY;

break;
default:
return cljs.core.PersistentVector.EMPTY;

}
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$1(com$wsscode$edn_json$thisfn),(function (){var G__57223 = cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(x__$1);
var G__57223__$1 = (cljs.core.truth_(lt)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__57223):G__57223);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lt,"list")){
return cljs.core.reverse(G__57223__$1);
} else {
return G__57223__$1;
}
})());
} else {
if(com.wsscode.edn_json.edn_value_str_QMARK_(x__$1)){
return com.wsscode.edn_json.decode_value(x__$1,opts);
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,k){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(r,com.wsscode.edn_json.decode_key(k),com$wsscode$edn_json$thisfn(com.wsscode.edn_json.goog$module$goog$object.get(x__$1,k)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),cljs.core.js_keys(x__$1)));
} else {
return x__$1;

}
}
}
}
}
}
}
});
return f(x);
}));

(com.wsscode.edn_json.json__GT_edn.cljs$lang$maxFixedArity = 2);

/**
 * Recursively transforms JavaScript arrays into ClojureScript
 *   vectors, and JavaScript objects into ClojureScript maps.
 * 
 *   Use to get fidelity restore of JSON data encoded with edn->json.
 */
com.wsscode.edn_json.json_like__GT_edn = (function com$wsscode$edn_json$json_like__GT_edn(var_args){
var G__57248 = arguments.length;
switch (G__57248) {
case 1:
return com.wsscode.edn_json.json_like__GT_edn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_json.json_like__GT_edn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_json.json_like__GT_edn.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_json.json_like__GT_edn.cljs$core$IFn$_invoke$arity$2(x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_json.json_like__GT_edn.cljs$core$IFn$_invoke$arity$2 = (function (x,opts){
var f = (function com$wsscode$edn_json$thisfn(x__$1){
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(com$wsscode$edn_json$thisfn,x__$1));
} else {
if(cljs.core.map_QMARK_(x__$1)){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,k){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(r,com.wsscode.edn_json.decode_key(k),com$wsscode$edn_json$thisfn(cljs.core.get.cljs$core$IFn$_invoke$arity$2(x__$1,k)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),cljs.core.keys(x__$1)));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var lt = com.wsscode.edn_json.list_type_STAR_(cljs.core.first(x__$1));
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((function (){var G__57282 = lt;
switch (G__57282) {
case "list":
return cljs.core.List.EMPTY;

break;
case "set":
return cljs.core.PersistentHashSet.EMPTY;

break;
default:
return cljs.core.PersistentVector.EMPTY;

}
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$1(com$wsscode$edn_json$thisfn),(function (){var G__57283 = x__$1;
var G__57283__$1 = (cljs.core.truth_(lt)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__57283):G__57283);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lt,"list")){
return cljs.core.reverse(G__57283__$1);
} else {
return G__57283__$1;
}
})());
} else {
return com.wsscode.edn_json.decode_value(x__$1,opts);

}
}
}
});
return f(x);
}));

(com.wsscode.edn_json.json_like__GT_edn.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=com.wsscode.edn_json.js.map
