goog.provide('cljs.analyzer.impl.namespaces');
/**
 * Given a libspec return a map of :as-alias alias, if was present. Return the
 * libspec with :as-alias elided. If the libspec was *only* :as-alias do not
 * return it.
 */
cljs.analyzer.impl.namespaces.check_and_remove_as_alias = (function cljs$analyzer$impl$namespaces$check_and_remove_as_alias(libspec){
if((((libspec instanceof cljs.core.Symbol)) || ((libspec instanceof cljs.core.Keyword)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec], null);
} else {
var vec__48479 = libspec;
var seq__48480 = cljs.core.seq(vec__48479);
var first__48481 = cljs.core.first(seq__48480);
var seq__48480__$1 = cljs.core.next(seq__48480);
var lib = first__48481;
var spec = seq__48480__$1;
var libspec__$1 = vec__48479;
var vec__48482 = cljs.core.split_with(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),null], null), null)),spec);
var pre_spec = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48482,(0),null);
var vec__48485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48482,(1),null);
var seq__48486 = cljs.core.seq(vec__48485);
var first__48487 = cljs.core.first(seq__48486);
var seq__48486__$1 = cljs.core.next(seq__48486);
var _ = first__48487;
var first__48487__$1 = cljs.core.first(seq__48486__$1);
var seq__48486__$2 = cljs.core.next(seq__48486__$1);
var alias = first__48487__$1;
var post_spec = seq__48486__$2;
var post = vec__48485;
if(cljs.core.seq(post)){
var libspec_SINGLEQUOTE_ = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(pre_spec,post_spec));
if((alias instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ",[":as-alias must be followed by a symbol, got: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias)].join(''),"\n","(symbol? alias)"].join('')));
}

var G__48491 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),cljs.core.PersistentArrayMap.createAsIfByAssoc([alias,lib])], null);
if((cljs.core.count(libspec_SINGLEQUOTE_) > (1))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__48491,new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec_SINGLEQUOTE_);
} else {
return G__48491;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec__$1], null);
}
}
});
cljs.analyzer.impl.namespaces.check_as_alias_duplicates = (function cljs$analyzer$impl$namespaces$check_as_alias_duplicates(as_aliases,new_as_aliases){
var seq__48496 = cljs.core.seq(new_as_aliases);
var chunk__48497 = null;
var count__48498 = (0);
var i__48499 = (0);
while(true){
if((i__48499 < count__48498)){
var vec__48520 = chunk__48497.cljs$core$IIndexed$_nth$arity$2(null,i__48499);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48520,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48520,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__48579 = seq__48496;
var G__48580 = chunk__48497;
var G__48581 = count__48498;
var G__48582 = (i__48499 + (1));
seq__48496 = G__48579;
chunk__48497 = G__48580;
count__48498 = G__48581;
i__48499 = G__48582;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__48496);
if(temp__5804__auto__){
var seq__48496__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48496__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__48496__$1);
var G__48584 = cljs.core.chunk_rest(seq__48496__$1);
var G__48585 = c__5568__auto__;
var G__48586 = cljs.core.count(c__5568__auto__);
var G__48587 = (0);
seq__48496 = G__48584;
chunk__48497 = G__48585;
count__48498 = G__48586;
i__48499 = G__48587;
continue;
} else {
var vec__48528 = cljs.core.first(seq__48496__$1);
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48528,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48528,(1),null);
if((!(cljs.core.contains_QMARK_(as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__48590 = cljs.core.next(seq__48496__$1);
var G__48591 = null;
var G__48592 = (0);
var G__48593 = (0);
seq__48496 = G__48590;
chunk__48497 = G__48591;
count__48498 = G__48592;
i__48499 = G__48593;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given libspecs, elide all :as-alias. Return a map of :libspecs (filtered)
 * and :as-aliases.
 */
cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_libspecs(var_args){
var G__48536 = arguments.length;
switch (G__48536) {
case 1:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1 = (function (libspecs){
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2 = (function (libspecs,as_aliases){
var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),as_aliases,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__$1,libspec){
var map__48541 = cljs.analyzer.impl.namespaces.check_and_remove_as_alias(libspec);
var map__48541__$1 = cljs.core.__destructure_map(map__48541);
var as_alias = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48541__$1,new cljs.core.Keyword(null,"as-alias","as-alias",82482467));
var libspec__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48541__$1,new cljs.core.Keyword(null,"libspec","libspec",1228503756));
cljs.analyzer.impl.namespaces.check_as_alias_duplicates(new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798).cljs$core$IFn$_invoke$arity$1(ret__$1),as_alias);

var G__48542 = ret__$1;
var G__48542__$1 = (cljs.core.truth_(libspec__$1)?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__48542,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,libspec__$1):G__48542);
if(cljs.core.truth_(as_alias)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__48542__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_alias);
} else {
return G__48542__$1;
}
}),ret,libspecs);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$lang$maxFixedArity = 2);

cljs.analyzer.impl.namespaces.elide_aliases_from_ns_specs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_ns_specs(ns_specs){

var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__48552,p__48553){
var map__48555 = p__48552;
var map__48555__$1 = cljs.core.__destructure_map(map__48555);
var ret__$1 = map__48555__$1;
var as_aliases = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48555__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var vec__48556 = p__48553;
var seq__48557 = cljs.core.seq(vec__48556);
var first__48558 = cljs.core.first(seq__48557);
var seq__48557__$1 = cljs.core.next(seq__48557);
var spec_key = first__48558;
var libspecs = seq__48557__$1;
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),spec_key)))){
var map__48563 = cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2(libspecs,as_aliases);
var map__48563__$1 = cljs.core.__destructure_map(map__48563);
var as_aliases__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48563__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var libspecs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48563__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195));
var G__48564 = ret__$1;
var G__48564__$1 = (((!(cljs.core.empty_QMARK_(as_aliases__$1))))?cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__48564,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_aliases__$1):G__48564);
if((!(cljs.core.empty_QMARK_(libspecs__$1)))){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(G__48564__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs__$1));
} else {
return G__48564__$1;
}
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(ret__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(spec_key,libspecs));
}
}),ret,ns_specs);
});

//# sourceMappingURL=cljs.analyzer.impl.namespaces.js.map
