(ns com.rycole.dat-json
  (require [clojure.data.json :as json]
           [ring.util.response :as ring]))

(defn wrap-json-response [handler]
  (fn [request]
    (let [response (handler request)]
      (if (coll? (:body response))
        (-> response
            (ring/content-type "application/json")
            (update-in [:body] json/write-str))
        response))))
