(ns lead.github.api
  (:require
    [compojure.core :refer [GET POST defroutes]]
    [lead.core :as core]
    [ring.util.response :as response]
    [ring.util.codec :as codec]
    [clj-http.client :as http]))

(defroutes handler
           (GET "/github/oauth/authorize" []
                (let [config (:github-api core/*configuration*)]
                  (response/redirect (str (:base-url config)
                                          "/login/oauth/authorize"
                                          "?client_id=" (codec/url-encode (:client-id config))
                                          "&redirect_uri=" (codec/url-encode (:redirect-uri config))
                                          "&scope=gist,repo"
                                          ; FIXME!!!
                                          "&state=hi"))))

           (POST "/github/oauth/token" [:as request]
                 ; TODO validate body, state
                 (let [body (:body request)
                       config (:github-api core/*configuration*)]
                   (try
                     (let [response (http/post (str (:base-url config) "/login/oauth/access_token")
                                               {:content-type :json
                                                :form-params {:client_id (:client-id config)
                                                              :client_secret (:client-secret config)
                                                              :code (get body "code")}
                                                :headers {"Accept" "application/json"}
                                                :as :json})]
                       {:status 200
                        :body (:body response)})
                     ; hide all details about underlying exception
                     (catch Exception ex (throw (ex-info "Failed exchanging token" {})))))))
