/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Content;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.io.impl.RSS090Parser;
import java.util.Locale;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class RSS10Parser
extends RSS090Parser {
    private static final String RSS_URI = "http://purl.org/rss/1.0/";
    private static final Namespace RSS_NS = Namespace.getNamespace((String)"http://purl.org/rss/1.0/");

    public RSS10Parser() {
        this("rss_1.0", RSS_NS);
    }

    protected RSS10Parser(String type, Namespace ns) {
        super(type, ns);
    }

    @Override
    public boolean isMyType(Document document) {
        Element channel;
        boolean ok = false;
        Element rssRoot = document.getRootElement();
        Namespace defaultNS = rssRoot.getNamespace();
        boolean bl = ok = defaultNS != null && defaultNS.equals((Object)this.getRDFNamespace());
        if (ok && (channel = rssRoot.getChild("channel", this.getRSSNamespace())) == null) {
            ok = false;
        }
        return ok;
    }

    @Override
    protected Namespace getRSSNamespace() {
        return Namespace.getNamespace((String)RSS_URI);
    }

    @Override
    protected Item parseItem(Element rssRoot, Element eItem, Locale locale) {
        String uri;
        Element ce;
        Item item = super.parseItem(rssRoot, eItem, locale);
        Element e = eItem.getChild("description", this.getRSSNamespace());
        if (e != null) {
            item.setDescription(this.parseItemDescription(rssRoot, e));
        }
        if ((ce = eItem.getChild("encoded", this.getContentNamespace())) != null) {
            Content content = new Content();
            content.setType("html");
            content.setValue(ce.getText());
            item.setContent(content);
        }
        if ((uri = eItem.getAttributeValue("about", this.getRDFNamespace())) != null) {
            item.setUri(uri);
        }
        return item;
    }

    @Override
    protected WireFeed parseChannel(Element rssRoot, Locale locale) {
        Channel channel = (Channel)super.parseChannel(rssRoot, locale);
        Element eChannel = rssRoot.getChild("channel", this.getRSSNamespace());
        String uri = eChannel.getAttributeValue("about", this.getRDFNamespace());
        if (uri != null) {
            channel.setUri(uri);
        }
        return channel;
    }

    protected Description parseItemDescription(Element rssRoot, Element eDesc) {
        Description desc = new Description();
        desc.setType("text/plain");
        desc.setValue(eDesc.getText());
        return desc;
    }
}

