/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.rss.Category;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Cloud;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Enclosure;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.feed.rss.Source;
import com.sun.syndication.io.impl.NumberParser;
import com.sun.syndication.io.impl.RSS091UserlandParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class RSS092Parser
extends RSS091UserlandParser {
    public RSS092Parser() {
        this("rss_0.92");
    }

    protected RSS092Parser(String type) {
        super(type);
    }

    @Override
    protected String getRSSVersion() {
        return "0.92";
    }

    @Override
    protected WireFeed parseChannel(Element rssRoot, Locale locale) {
        Channel channel = (Channel)super.parseChannel(rssRoot, locale);
        Element eChannel = rssRoot.getChild("channel", this.getRSSNamespace());
        Element eCloud = eChannel.getChild("cloud", this.getRSSNamespace());
        if (eCloud != null) {
            Cloud cloud = new Cloud();
            String att = eCloud.getAttributeValue("domain");
            if (att != null) {
                cloud.setDomain(att);
            }
            if ((att = eCloud.getAttributeValue("port")) != null) {
                cloud.setPort(Integer.parseInt(att.trim()));
            }
            if ((att = eCloud.getAttributeValue("path")) != null) {
                cloud.setPath(att);
            }
            if ((att = eCloud.getAttributeValue("registerProcedure")) != null) {
                cloud.setRegisterProcedure(att);
            }
            if ((att = eCloud.getAttributeValue("protocol")) != null) {
                cloud.setProtocol(att);
            }
            channel.setCloud(cloud);
        }
        return channel;
    }

    @Override
    protected Item parseItem(Element rssRoot, Element eItem, Locale locale) {
        List eEnclosures;
        Item item = super.parseItem(rssRoot, eItem, locale);
        Element e = eItem.getChild("source", this.getRSSNamespace());
        if (e != null) {
            Source source = new Source();
            String url = e.getAttributeValue("url");
            source.setUrl(url);
            source.setValue(e.getText());
            item.setSource(source);
        }
        if ((eEnclosures = eItem.getChildren("enclosure")).size() > 0) {
            ArrayList<Enclosure> enclosures = new ArrayList<Enclosure>();
            for (int i = 0; i < eEnclosures.size(); ++i) {
                e = (Element)eEnclosures.get(i);
                Enclosure enclosure = new Enclosure();
                String att = e.getAttributeValue("url");
                if (att != null) {
                    enclosure.setUrl(att);
                }
                att = e.getAttributeValue("length");
                enclosure.setLength(NumberParser.parseLong(att, 0L));
                att = e.getAttributeValue("type");
                if (att != null) {
                    enclosure.setType(att);
                }
                enclosures.add(enclosure);
            }
            item.setEnclosures(enclosures);
        }
        List eCats = eItem.getChildren("category");
        item.setCategories(this.parseCategories(eCats));
        return item;
    }

    protected List<Category> parseCategories(List<Element> eCats) {
        ArrayList<Category> cats = null;
        if (eCats.size() > 0) {
            cats = new ArrayList<Category>();
            for (int i = 0; i < eCats.size(); ++i) {
                Category cat = new Category();
                Element e = eCats.get(i);
                String att = e.getAttributeValue("domain");
                if (att != null) {
                    cat.setDomain(att);
                }
                cat.setValue(e.getText());
                cats.add(cat);
            }
        }
        return cats;
    }

    @Override
    protected Description parseItemDescription(Element rssRoot, Element eDesc) {
        Description desc = new Description();
        StringBuilder sb = new StringBuilder();
        XMLOutputter xmlOut = new XMLOutputter();
        for (Content c : eDesc.getContent()) {
            switch (c.getCType()) {
                case Text: 
                case CDATA: {
                    sb.append(c.getValue());
                    break;
                }
                case EntityRef: {
                    System.out.println("entity: " + c.getValue());
                    sb.append(c.getValue());
                    break;
                }
                case Element: {
                    sb.append(xmlOut.outputString((Element)c));
                    break;
                }
            }
        }
        desc.setValue(sb.toString());
        String att = eDesc.getAttributeValue("type");
        if (att == null) {
            att = "text/html";
        }
        desc.setType(att);
        return desc;
    }
}

