/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.impl;

import com.sun.syndication.feed.CopyFrom;
import com.sun.syndication.feed.impl.BeanIntrospector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CopyFromHelper {
    private static final Object[] NO_PARAMS = new Object[0];
    private final Class<? extends CopyFrom<?>> beanInterfaceClass;
    private final Map<String, Class<?>> baseInterfaceMap;
    private final Map<Class<? extends CopyFrom<?>>, Class<?>> baseImplMap;
    private static final Set<Class<?>> BASIC_TYPES = new HashSet();

    public CopyFromHelper(Class<? extends CopyFrom<?>> beanInterfaceClass, Map<String, Class<?>> basePropInterfaceMap, Map<Class<? extends CopyFrom<?>>, Class<?>> basePropClassImplMap) {
        this.beanInterfaceClass = beanInterfaceClass;
        this.baseInterfaceMap = basePropInterfaceMap;
        this.baseImplMap = basePropClassImplMap;
    }

    public void copy(Object target, Object source) {
        try {
            PropertyDescriptor[] pds = BeanIntrospector.getPropertyDescriptors(this.beanInterfaceClass);
            if (pds != null) {
                for (PropertyDescriptor pd : pds) {
                    Object value;
                    String propertyName = pd.getName();
                    Method pReadMethod = pd.getReadMethod();
                    Method pWriteMethod = pd.getWriteMethod();
                    if (pReadMethod == null || pWriteMethod == null || pReadMethod.getDeclaringClass() == Object.class || pReadMethod.getParameterTypes().length != 0 || !this.baseInterfaceMap.containsKey(propertyName) || (value = pReadMethod.invoke(source, NO_PARAMS)) == null) continue;
                    Class<?> baseInterface = this.baseInterfaceMap.get(propertyName);
                    value = this.doCopy(value, baseInterface);
                    pWriteMethod.invoke(target, value);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not do a copyFrom " + ex, ex);
        }
    }

    private CopyFrom<?> createInstance(Class<? extends CopyFrom<?>> interfaceClass) throws Exception {
        if (this.baseImplMap.get(interfaceClass) == null) {
            return null;
        }
        return (CopyFrom)this.baseImplMap.get(interfaceClass).newInstance();
    }

    private <T> T doCopy(T value, Class<?> baseInterface) throws Exception {
        if (value != null) {
            Class<?> vClass = value.getClass();
            if (vClass.isArray()) {
                value = this.doCopyArray((Object[])value, baseInterface);
            } else if (value instanceof Collection) {
                value = this.doCopyCollection((Collection)value, baseInterface);
            } else if (value instanceof Map) {
                value = this.doCopyMap((Map)value, baseInterface);
            } else if (this.isBasicType(vClass)) {
                if (value instanceof Date) {
                    value = ((Date)value).clone();
                }
            } else if (value instanceof CopyFrom) {
                CopyFrom source = (CopyFrom)value;
                CopyFrom target = this.createInstance(source.getInterface());
                if (target == null) {
                    target = (CopyFrom)value.getClass().newInstance();
                }
                target.copyFrom(source);
                value = target;
            } else {
                throw new Exception("unsupported class for 'copyFrom' " + value.getClass());
            }
        }
        return (T)value;
    }

    private <T> T[] doCopyArray(T[] array, Class<?> baseInterface) throws Exception {
        Class<?> elementClass = array.getClass().getComponentType();
        int length = Array.getLength(array);
        Object[] newArray = (Object[])Array.newInstance(elementClass, length);
        for (int i = 0; i < length; ++i) {
            Object element = this.doCopy(Array.get(array, i), baseInterface);
            Array.set(newArray, i, element);
        }
        return newArray;
    }

    private <T> Collection<T> doCopyCollection(Collection<T> collection, Class<?> baseInterface) throws Exception {
        AbstractCollection newColl = collection instanceof Set ? new LinkedHashSet() : new ArrayList();
        Iterator<T> i = collection.iterator();
        while (i.hasNext()) {
            newColl.add(this.doCopy(i.next(), baseInterface));
        }
        return newColl;
    }

    private <S, T> Map<S, T> doCopyMap(Map<S, T> map, Class<?> baseInterface) throws Exception {
        HashMap<S, T> newMap = new HashMap<S, T>();
        for (Map.Entry<S, T> entry : map.entrySet()) {
            newMap.put(entry.getKey(), this.doCopy(entry.getValue(), baseInterface));
        }
        return newMap;
    }

    private boolean isBasicType(Class<?> vClass) {
        return BASIC_TYPES.contains(vClass);
    }

    static {
        BASIC_TYPES.add(Boolean.class);
        BASIC_TYPES.add(Byte.class);
        BASIC_TYPES.add(Character.class);
        BASIC_TYPES.add(Double.class);
        BASIC_TYPES.add(Float.class);
        BASIC_TYPES.add(Integer.class);
        BASIC_TYPES.add(Long.class);
        BASIC_TYPES.add(Short.class);
        BASIC_TYPES.add(String.class);
        BASIC_TYPES.add(Date.class);
    }
}

