/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.DecoderBase;
import zmq.IMsgSink;
import zmq.Msg;
import zmq.ZError;

public class V1Decoder
extends DecoderBase {
    private static final int one_byte_size_ready = 0;
    private static final int eight_byte_size_ready = 1;
    private static final int flags_ready = 2;
    private static final int message_ready = 3;
    private final byte[] tmpbuf;
    private Msg in_progress;
    private IMsgSink msg_sink;
    private final long maxmsgsize;
    private int msg_flags;

    public V1Decoder(int bufsize_, long maxmsgsize_, IMsgSink session) {
        super(bufsize_);
        this.maxmsgsize = maxmsgsize_;
        this.msg_sink = session;
        this.tmpbuf = new byte[8];
        this.next_step(this.tmpbuf, 1, 2);
    }

    public void set_msg_sink(IMsgSink msg_sink_) {
        this.msg_sink = msg_sink_;
    }

    protected boolean next() {
        switch (this.state()) {
            case 0: {
                return this.one_byte_size_ready();
            }
            case 1: {
                return this.eight_byte_size_ready();
            }
            case 2: {
                return this.flags_ready();
            }
            case 3: {
                return this.message_ready();
            }
        }
        return false;
    }

    private boolean one_byte_size_ready() {
        int size = this.tmpbuf[0];
        if (size < 0) {
            size = 0xFF & size;
        }
        if (this.maxmsgsize >= 0L && (long)size > this.maxmsgsize) {
            this.decoding_error();
            return false;
        }
        this.in_progress = new Msg(size);
        this.in_progress.set_flags(this.msg_flags);
        this.next_step(this.in_progress.data(), this.in_progress.size(), 3);
        return true;
    }

    private boolean eight_byte_size_ready() {
        long msg_size = ByteBuffer.wrap(this.tmpbuf).getLong();
        if (this.maxmsgsize >= 0L && msg_size > this.maxmsgsize) {
            this.decoding_error();
            return false;
        }
        if (msg_size > Integer.MAX_VALUE) {
            this.decoding_error();
            return false;
        }
        this.in_progress = new Msg((int)msg_size);
        this.in_progress.set_flags(this.msg_flags);
        this.next_step(this.in_progress.data(), this.in_progress.size(), 3);
        return true;
    }

    private boolean flags_ready() {
        this.msg_flags = 0;
        byte first = this.tmpbuf[0];
        if ((first & 1) > 0) {
            this.msg_flags |= 1;
        }
        if ((first & 2) > 0) {
            this.next_step(this.tmpbuf, 8, 1);
        } else {
            this.next_step(this.tmpbuf, 1, 0);
        }
        return true;
    }

    private boolean message_ready() {
        if (this.msg_sink == null) {
            return false;
        }
        boolean rc = this.msg_sink.push_msg(this.in_progress);
        if (!rc) {
            if (!ZError.is(35)) {
                this.decoding_error();
            }
            return false;
        }
        this.next_step(this.tmpbuf, 1, 2);
        return true;
    }
}

