/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.Router;
import zmq.SocketBase;

public class Rep
extends Router {
    private boolean sending_reply = false;
    private boolean request_begins = true;

    public Rep(Ctx parent_, int tid_, int sid_) {
        super(parent_, tid_, sid_);
        this.options.type = 4;
    }

    protected boolean xsend(Msg msg_, int flags_) {
        if (!this.sending_reply) {
            throw new IllegalStateException("Cannot send another reply");
        }
        boolean more = msg_.has_more();
        boolean rc = super.xsend(msg_, flags_);
        if (!rc) {
            return rc;
        }
        if (!more) {
            this.sending_reply = false;
        }
        return true;
    }

    protected Msg xrecv(int flags_) {
        Msg msg_;
        if (this.sending_reply) {
            throw new IllegalStateException("Cannot receive another request");
        }
        if (this.request_begins) {
            while (true) {
                if ((msg_ = super.xrecv(flags_)) == null) {
                    return null;
                }
                if (msg_.has_more()) {
                    boolean bottom = msg_.size() == 0;
                    boolean rc = super.xsend(msg_, flags_);
                    assert (rc);
                    if (!bottom) continue;
                    break;
                }
                super.rollback();
            }
            this.request_begins = false;
        }
        if ((msg_ = super.xrecv(flags_)) == null) {
            return null;
        }
        if (!msg_.has_more()) {
            this.sending_reply = true;
            this.request_begins = true;
        }
        return msg_;
    }

    protected boolean xhas_in() {
        if (this.sending_reply) {
            return false;
        }
        return super.xhas_in();
    }

    protected boolean xhas_out() {
        if (!this.sending_reply) {
            return false;
        }
        return super.xhas_out();
    }

    public static class RepSession
    extends Router.RouterSession {
        public RepSession(IOThread io_thread_, boolean connect_, SocketBase socket_, Options options_, Address addr_) {
            super(io_thread_, connect_, socket_, options_, addr_);
        }
    }
}

