/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import zmq.IPollEvents;
import zmq.PollerBase;
import zmq.ZError;

public class Poller
extends PollerBase
implements Runnable {
    private final Map<SelectableChannel, PollSet> fd_table;
    private boolean retired;
    private volatile boolean stopping;
    private volatile boolean stopped;
    private Thread worker;
    private final Selector selector;
    private final String name;

    public Poller() {
        this("poller");
    }

    public Poller(String name_) {
        this.name = name_;
        this.retired = false;
        this.stopping = false;
        this.stopped = false;
        this.fd_table = new HashMap<SelectableChannel, PollSet>();
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
    }

    public void destroy() {
        if (!this.stopped) {
            try {
                this.worker.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final void add_fd(SelectableChannel fd_, IPollEvents events_) {
        this.fd_table.put(fd_, new PollSet(events_));
        this.adjust_load(1);
    }

    public final void rm_fd(SelectableChannel handle) {
        this.fd_table.get((Object)handle).cancelled = true;
        this.retired = true;
        this.adjust_load(-1);
    }

    public final void set_pollin(SelectableChannel handle_) {
        this.register(handle_, 1, false);
    }

    public final void reset_pollin(SelectableChannel handle_) {
        this.register(handle_, 1, true);
    }

    public final void set_pollout(SelectableChannel handle_) {
        this.register(handle_, 4, false);
    }

    public final void reset_pollout(SelectableChannel handle_) {
        this.register(handle_, 4, true);
    }

    public final void set_pollconnect(SelectableChannel handle_) {
        this.register(handle_, 8, false);
    }

    public final void set_pollaccept(SelectableChannel handle_) {
        this.register(handle_, 16, false);
    }

    private final void register(SelectableChannel handle_, int ops, boolean negate) {
        PollSet pollset = this.fd_table.get(handle_);
        pollset.ops = negate ? (pollset.ops &= ~ops) : (pollset.ops |= ops);
        if (pollset.key != null) {
            pollset.key.interestOps(pollset.ops);
        } else {
            this.retired = true;
        }
    }

    public void start() {
        this.worker = new Thread((Runnable)this, this.name);
        this.worker.start();
    }

    public void stop() {
        this.stopping = true;
        this.selector.wakeup();
    }

    public void run() {
        while (!this.stopping) {
            int rc;
            long timeout = this.execute_timers();
            if (this.retired) {
                Iterator<Map.Entry<SelectableChannel, PollSet>> it = this.fd_table.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<SelectableChannel, PollSet> entry = it.next();
                    SelectableChannel ch = entry.getKey();
                    PollSet pollset = entry.getValue();
                    if (pollset.key == null) {
                        try {
                            pollset.key = ch.register(this.selector, pollset.ops, pollset.handler);
                        }
                        catch (ClosedChannelException e) {}
                        continue;
                    }
                    if (!pollset.cancelled) continue;
                    pollset.key.cancel();
                    it.remove();
                }
                this.retired = false;
            }
            try {
                rc = this.selector.select(timeout);
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
            if (rc == 0) continue;
            Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                IPollEvents evt = (IPollEvents)key.attachment();
                it.remove();
                try {
                    if (key.isReadable()) {
                        evt.in_event();
                    } else if (key.isAcceptable()) {
                        evt.accept_event();
                    } else if (key.isConnectable()) {
                        evt.connect_event();
                    }
                    if (!key.isWritable()) continue;
                    evt.out_event();
                }
                catch (CancelledKeyException e) {}
            }
        }
        this.stopped = true;
    }

    private static class PollSet {
        protected IPollEvents handler;
        protected SelectionKey key;
        protected int ops;
        protected boolean cancelled;

        protected PollSet(IPollEvents handler) {
            this.handler = handler;
            this.key = null;
            this.cancelled = false;
            this.ops = 0;
        }
    }
}

