/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class Msg {
    public static final int more = 1;
    public static final int identity = 64;
    public static final int shared = 128;
    private static final byte type_min = 101;
    private static final byte type_vsm = 102;
    private static final byte type_lmsg = 103;
    private static final byte type_delimiter = 104;
    private static final byte type_max = 105;
    private byte type;
    private int flags;
    private int size;
    private byte[] header;
    private byte[] data;
    private ByteBuffer buf;

    public Msg() {
        this.init((byte)102);
    }

    public Msg(boolean buffered) {
        if (buffered) {
            this.init((byte)103);
        } else {
            this.init((byte)102);
        }
    }

    public Msg(int size) {
        this.init((byte)102);
        this.size(size);
    }

    public Msg(int size, boolean buffered) {
        if (buffered) {
            this.init((byte)103);
        } else {
            this.init((byte)102);
        }
        this.size(size);
    }

    public Msg(Msg m) {
        this.clone(m);
    }

    public Msg(byte[] src) {
        this(src, false);
    }

    public Msg(String src) {
        this(src.getBytes(), false);
    }

    public Msg(byte[] src, boolean copy) {
        this();
        if (src != null) {
            this.size = src.length;
            this.data = copy ? Arrays.copyOf(src, src.length) : src;
        }
    }

    public Msg(ByteBuffer src) {
        this.init((byte)103);
        this.buf = src.duplicate();
        this.buf.rewind();
        this.size = this.buf.remaining();
    }

    public final boolean is_identity() {
        return (this.flags & 0x40) == 64;
    }

    public final boolean is_delimiter() {
        return this.type == 104;
    }

    public final boolean check() {
        return this.type >= 101 && this.type <= 105;
    }

    private final void init(byte type_) {
        this.type = type_;
        this.flags = 0;
        this.size = 0;
        this.data = null;
        this.buf = null;
        this.header = null;
    }

    public final void size(int size_) {
        this.size = size_;
        if (this.type == 103) {
            this.flags = 0;
            this.buf = ByteBuffer.allocate(size_);
            this.data = null;
        } else {
            this.flags = 0;
            this.data = new byte[size_];
            this.buf = null;
        }
    }

    public final int flags() {
        return this.flags;
    }

    public final boolean has_more() {
        return (this.flags & 1) > 0;
    }

    public final byte type() {
        return this.type;
    }

    public final void set_flags(int flags_) {
        this.flags |= flags_;
    }

    public final void init_delimiter() {
        this.type = (byte)104;
        this.flags = 0;
    }

    public final byte[] data() {
        if (this.data == null && this.type == 103) {
            this.data = this.buf.array();
        }
        return this.data;
    }

    public final ByteBuffer buf() {
        if (this.buf == null && this.type != 103) {
            this.buf = ByteBuffer.wrap(this.data);
        }
        return this.buf;
    }

    public final int size() {
        return this.size;
    }

    public final int header_size() {
        if (this.header == null) {
            if (this.size < 255) {
                return 2;
            }
            return 10;
        }
        if (this.header[0] == 255) {
            return 10;
        }
        return 2;
    }

    public final byte[] header() {
        if (this.header == null) {
            if (this.size < 255) {
                this.header = new byte[2];
                this.header[0] = (byte)this.size;
                this.header[1] = (byte)this.flags;
            } else {
                this.header = new byte[10];
                ByteBuffer hbuf = ByteBuffer.wrap(this.header);
                hbuf.put((byte)-1);
                hbuf.put((byte)this.flags);
                hbuf.putLong(this.size);
            }
        }
        return this.header;
    }

    public final ByteBuffer header_buf() {
        return ByteBuffer.wrap(this.header());
    }

    public final void close() {
        if (!this.check()) {
            throw new IllegalStateException();
        }
        this.init((byte)102);
    }

    public String toString() {
        return super.toString() + "[" + this.type + "," + this.size + "," + this.flags + "]";
    }

    private void clone(Msg m) {
        this.type = m.type;
        this.flags = m.flags;
        this.size = m.size;
        this.buf = m.buf;
        this.data = m.data;
    }

    public final void reset_flags(int f) {
        this.flags &= ~f;
    }

    public final void put(byte[] src, int i) {
        if (src == null) {
            return;
        }
        System.arraycopy(src, 0, this.data, i, src.length);
    }

    public final void put(byte[] src, int i, int len_) {
        if (len_ == 0 || src == null) {
            return;
        }
        System.arraycopy(src, 0, this.data, i, len_);
    }

    public final boolean is_vsm() {
        return this.type == 102;
    }

    public final void put(byte b) {
        this.data[0] = b;
    }

    public final void put(byte b, int i) {
        this.data[i] = b;
    }

    public final void put(String str, int i) {
        this.put(str.getBytes(), i);
    }

    public final void put(Msg data, int i) {
        this.put(data.data, i);
    }
}

