/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import java.util.Arrays;
import zmq.Utils;

public class Blob {
    private byte[] buf;
    private int hash = 0;

    public Blob(byte[] data_) {
        this.buf = Arrays.copyOf(data_, data_.length);
    }

    public Blob(int size) {
        this.buf = new byte[size];
    }

    public Blob(ByteBuffer buf_) {
        this.buf = Utils.bytes(buf_);
    }

    public Blob put(int pos, byte b) {
        this.buf[pos] = b;
        this.hash = 0;
        return this;
    }

    public Blob put(int pos, byte[] data) {
        System.arraycopy(data, 0, this.buf, pos, data.length);
        this.hash = 0;
        return this;
    }

    public int size() {
        return this.buf.length;
    }

    public byte[] data() {
        return this.buf;
    }

    public boolean equals(Object t) {
        if (t instanceof Blob) {
            return Arrays.equals(this.buf, ((Blob)t).buf);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            for (byte b : this.buf) {
                this.hash = 31 * this.hash + b;
            }
        }
        return this.hash;
    }
}

