/*
 * Decompiled with CFR 0.152.
 */
package org.jeromq;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.List;
import org.jeromq.ZMQ;
import zmq.Msg;
import zmq.PollItem;
import zmq.SocketBase;
import zmq.ZError;
import zmq.ZMQ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZDevice {
    public static boolean addressDevice(ZMQ.Socket insocket, ZMQ.Socket outsocket, List<byte[]> identities) {
        int rc;
        Selector selector;
        SocketBase insocket_ = insocket.base();
        SocketBase outsocket_ = outsocket.base();
        boolean success = true;
        boolean sentAddress = false;
        boolean recvAddress = false;
        int size = identities.size();
        PollItem[] items = new PollItem[2];
        if (insocket_.getsockopt(16) != 6 || outsocket_.getsockopt(16) != 6) {
            throw new IllegalArgumentException("Both router socket is required");
        }
        items[0] = new PollItem(insocket_, 1);
        items[1] = new PollItem(outsocket_, 1);
        try {
            selector = Selector.open();
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        block4: while (success && (rc = ZMQ.zmq_poll(selector, items, -1L)) >= 0) {
            Msg msg;
            long more;
            block14: {
                if (items[0].isReadable()) {
                    do {
                        if ((msg = insocket_.recv(0)) == null) {
                            success = false;
                            break block14;
                        }
                        if (!sentAddress) {
                            byte[] target;
                            int hint = msg.data()[0];
                            if (hint < 0) {
                                hint = 0xFF & hint;
                            }
                            if (!(success = outsocket_.send(new Msg(target = identities.get(hint % size)), 2))) break block14;
                            sentAddress = true;
                        }
                        if (!(success = outsocket_.send(msg, (more = (long)insocket_.getsockopt(13)) > 0L ? 2 : 0))) break block14;
                    } while (more != 0L);
                    sentAddress = false;
                }
            }
            if (!success || !items[1].isReadable()) continue;
            while (true) {
                if ((msg = outsocket_.recv(0)) == null) {
                    success = false;
                    continue block4;
                }
                if (!recvAddress) {
                    recvAddress = true;
                    continue;
                }
                more = outsocket_.getsockopt(13);
                success = insocket_.send(msg, more > 0L ? 2 : 0);
                if (!success) continue block4;
                if (more == 0L) break;
            }
            recvAddress = false;
        }
        try {
            selector.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return success;
    }

    public static interface IdentityFinder {
        public byte[] findIdentity(byte[] var1);
    }
}

