/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AbstractMultithreadedClaimStrategy;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.Sequence;
import java.util.concurrent.atomic.AtomicLongArray;

public final class MultiThreadedClaimStrategy
extends AbstractMultithreadedClaimStrategy
implements ClaimStrategy {
    private static final int RETRIES = 1000;
    private final AtomicLongArray pendingPublication;
    private final int pendingMask;

    public MultiThreadedClaimStrategy(int bufferSize, int pendingBufferSize) {
        super(bufferSize);
        if (Integer.bitCount(pendingBufferSize) != 1) {
            throw new IllegalArgumentException("pendingBufferSize must be a power of 2, was: " + pendingBufferSize);
        }
        this.pendingPublication = new AtomicLongArray(pendingBufferSize);
        this.pendingMask = pendingBufferSize - 1;
    }

    public MultiThreadedClaimStrategy(int bufferSize) {
        this(bufferSize, 1024);
    }

    @Override
    public void serialisePublishing(long sequence, Sequence cursor, int batchSize) {
        int counter = 1000;
        while (sequence - cursor.get() > (long)this.pendingPublication.length()) {
            if (--counter != 0) continue;
            Thread.yield();
            counter = 1000;
        }
        long expectedSequence = sequence - (long)batchSize;
        for (long pendingSequence = expectedSequence + 1L; pendingSequence < sequence; ++pendingSequence) {
            this.pendingPublication.lazySet((int)pendingSequence & this.pendingMask, pendingSequence);
        }
        this.pendingPublication.set((int)sequence & this.pendingMask, sequence);
        long cursorSequence = cursor.get();
        if (cursorSequence >= sequence) {
            return;
        }
        expectedSequence = Math.max(expectedSequence, cursorSequence);
        long nextSequence = expectedSequence + 1L;
        while (cursor.compareAndSet(expectedSequence, nextSequence)) {
            expectedSequence = nextSequence++;
            if (this.pendingPublication.get((int)nextSequence & this.pendingMask) == nextSequence) continue;
            break;
        }
    }
}

