/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathAndBytesable;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.PathAndBytesable;
import com.netflix.curator.framework.api.SetDataBuilder;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.PathAndBytes;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.data.Stat;

class SetDataBuilderImpl
implements SetDataBuilder,
BackgroundOperation<PathAndBytes> {
    private final CuratorFrameworkImpl client;
    private Backgrounding backgrounding;
    private int version;

    SetDataBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.version = -1;
    }

    @Override
    public BackgroundPathAndBytesable<Stat> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public PathAndBytesable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("SetDataBuilderImpl-Background");
        this.client.getZooKeeper().setData(operationAndData.getData().getPath(), operationAndData.getData().getData(), this.version, new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                trace.commit();
                CuratorEventImpl event = new CuratorEventImpl(SetDataBuilderImpl.this.client, CuratorEventType.SET_DATA, rc, path, null, ctx, stat, null, null, null, null);
                SetDataBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        }, this.backgrounding.getContext());
    }

    @Override
    public Stat forPath(String path) throws Exception {
        return this.forPath(path, this.client.getDefaultData());
    }

    @Override
    public Stat forPath(String path, byte[] data) throws Exception {
        path = this.client.fixForNamespace(path);
        Stat resultStat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<PathAndBytes>(this, new PathAndBytes(path, data), this.backgrounding.getCallback()), null);
        } else {
            resultStat = this.pathInForeground(path, data);
        }
        return resultStat;
    }

    private Stat pathInForeground(final String path, final byte[] data) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("SetDataBuilderImpl-Foreground");
        Stat resultStat = (Stat)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                return SetDataBuilderImpl.this.client.getZooKeeper().setData(path, data, SetDataBuilderImpl.this.version);
            }
        });
        trace.commit();
        return resultStat;
    }
}

