/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.framework.imps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.TimeTrace;
import com.netflix.curator.framework.api.ACLBackgroundPathAndBytesable;
import com.netflix.curator.framework.api.ACLCreateModePathAndBytesable;
import com.netflix.curator.framework.api.ACLPathAndBytesable;
import com.netflix.curator.framework.api.BackgroundCallback;
import com.netflix.curator.framework.api.BackgroundPathAndBytesable;
import com.netflix.curator.framework.api.CreateBuilder;
import com.netflix.curator.framework.api.CuratorEventType;
import com.netflix.curator.framework.api.PathAndBytesable;
import com.netflix.curator.framework.imps.ACLing;
import com.netflix.curator.framework.imps.BackgroundOperation;
import com.netflix.curator.framework.imps.Backgrounding;
import com.netflix.curator.framework.imps.CuratorEventImpl;
import com.netflix.curator.framework.imps.CuratorFrameworkImpl;
import com.netflix.curator.framework.imps.OperationAndData;
import com.netflix.curator.framework.imps.PathAndBytes;
import com.netflix.curator.utils.ZKPaths;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;

class CreateBuilderImpl
implements CreateBuilder,
BackgroundOperation<PathAndBytes> {
    private final CuratorFrameworkImpl client;
    private CreateMode createMode;
    private Backgrounding backgrounding;
    private boolean createParentsIfNeeded;
    private boolean doProtectedEphemeralSequential;
    private String protectedEphemeralSequentialId;
    private ACLing acling;
    @VisibleForTesting
    boolean failNextCreateForTesting = false;
    @VisibleForTesting
    static final String PROTECTED_PREFIX = "_c_";

    CreateBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.createMode = CreateMode.PERSISTENT;
        this.backgrounding = new Backgrounding();
        this.acling = new ACLing();
        this.createParentsIfNeeded = false;
        this.doProtectedEphemeralSequential = false;
        this.protectedEphemeralSequentialId = null;
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
        this.acling = new ACLing(aclList);
        return new ACLBackgroundPathAndBytesable<String>(){

            @Override
            public BackgroundPathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public PathAndBytesable<String> inBackground() {
                return CreateBuilderImpl.this.inBackground();
            }

            @Override
            public PathAndBytesable<String> inBackground(Object context) {
                return CreateBuilderImpl.this.inBackground(context);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
                return CreateBuilderImpl.this.inBackground(callback);
            }

            @Override
            public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
                return CreateBuilderImpl.this.inBackground(callback, executor);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLCreateModePathAndBytesable<String> creatingParentsIfNeeded() {
        this.createParentsIfNeeded = true;
        return new ACLCreateModePathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public ACLPathAndBytesable<String> withMode(CreateMode mode) {
                CreateBuilderImpl.this.createMode = mode;
                return new ACLPathAndBytesable<String>(){

                    @Override
                    public PathAndBytesable<String> withACL(List<ACL> aclList) {
                        return CreateBuilderImpl.this.withACL((List)aclList);
                    }

                    @Override
                    public String forPath(String path, byte[] data) throws Exception {
                        return CreateBuilderImpl.this.forPath(path, data);
                    }

                    @Override
                    public String forPath(String path) throws Exception {
                        return CreateBuilderImpl.this.forPath(path);
                    }
                };
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLPathAndBytesable<String> withProtectedEphemeralSequential() {
        this.doProtectedEphemeralSequential = true;
        this.protectedEphemeralSequentialId = UUID.randomUUID().toString();
        this.createMode = CreateMode.EPHEMERAL_SEQUENTIAL;
        return new ACLPathAndBytesable<String>(){

            @Override
            public PathAndBytesable<String> withACL(List<ACL> aclList) {
                return CreateBuilderImpl.this.withACL((List)aclList);
            }

            @Override
            public String forPath(String path, byte[] data) throws Exception {
                return CreateBuilderImpl.this.forPath(path, data);
            }

            @Override
            public String forPath(String path) throws Exception {
                return CreateBuilderImpl.this.forPath(path);
            }
        };
    }

    @Override
    public ACLBackgroundPathAndBytesable<String> withMode(CreateMode mode) {
        this.createMode = mode;
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public PathAndBytesable<String> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public String forPath(String path) throws Exception {
        return this.forPath(path, this.client.getDefaultData());
    }

    @Override
    public String forPath(String path, byte[] data) throws Exception {
        path = this.client.fixForNamespace(path);
        String returnPath = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<PathAndBytes>(this, new PathAndBytes(path, data), this.backgrounding.getCallback()), null);
        } else {
            returnPath = this.pathInForeground(path, data);
            returnPath = this.client.unfixForNamespace(returnPath);
        }
        return returnPath;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<PathAndBytes> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-Background");
        this.client.getZooKeeper().create(operationAndData.getData().getPath(), operationAndData.getData().getData(), this.acling.getAclList(), this.createMode, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                path = CreateBuilderImpl.this.client.unfixForNamespace(path);
                name = CreateBuilderImpl.this.client.unfixForNamespace(name);
                trace.commit();
                CuratorEventImpl event = new CuratorEventImpl(CreateBuilderImpl.this.client, CuratorEventType.CREATE, rc, path, name, ctx, null, null, null, null, null);
                CreateBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
            }
        }, this.backgrounding.getContext());
    }

    private String pathInForeground(final String path, final byte[] data) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-Foreground");
        final AtomicBoolean firstTime = new AtomicBoolean(true);
        String returnPath = (String)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                boolean localFirstTime = firstTime.getAndSet(false);
                String localPath = CreateBuilderImpl.this.adjustPath(path);
                if (CreateBuilderImpl.this.createParentsIfNeeded) {
                    ZKPaths.mkdirs((ZooKeeper)CreateBuilderImpl.this.client.getZooKeeper(), (String)localPath, (boolean)false);
                }
                String createdPath = null;
                if (!localFirstTime && CreateBuilderImpl.this.doProtectedEphemeralSequential) {
                    createdPath = CreateBuilderImpl.this.findProtectedNodeInForeground(localPath);
                }
                if (createdPath == null) {
                    createdPath = CreateBuilderImpl.this.client.getZooKeeper().create(localPath, data, CreateBuilderImpl.this.acling.getAclList(), CreateBuilderImpl.this.createMode);
                }
                if (CreateBuilderImpl.this.failNextCreateForTesting) {
                    CreateBuilderImpl.this.failNextCreateForTesting = false;
                    throw new KeeperException.ConnectionLossException();
                }
                return createdPath;
            }
        });
        trace.commit();
        return returnPath;
    }

    private String findProtectedNodeInForeground(final String path) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("CreateBuilderImpl-findProtectedNodeInForeground");
        String returnPath = (String)RetryLoop.callWithRetry((CuratorZookeeperClient)this.client.getZookeeperClient(), (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String foundNode = null;
                try {
                    ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
                    List children = CreateBuilderImpl.this.client.getZooKeeper().getChildren(pathAndNode.getPath(), false);
                    final String protectedPrefix = CreateBuilderImpl.this.getProtectedPrefix();
                    foundNode = (String)Iterables.find((Iterable)children, (Predicate)new Predicate<String>(){

                        public boolean apply(String node) {
                            return node.startsWith(protectedPrefix);
                        }
                    }, null);
                    if (foundNode != null) {
                        foundNode = ZKPaths.makePath((String)pathAndNode.getPath(), (String)foundNode);
                    }
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
                return foundNode;
            }
        });
        trace.commit();
        return returnPath;
    }

    private String adjustPath(String path) throws Exception {
        if (this.doProtectedEphemeralSequential) {
            ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
            String name = this.getProtectedPrefix() + pathAndNode.getNode();
            path = ZKPaths.makePath((String)pathAndNode.getPath(), (String)name);
        }
        return path;
    }

    private String getProtectedPrefix() throws Exception {
        return PROTECTED_PREFIX + this.protectedEphemeralSequentialId + "-";
    }
}

