/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.udppacket;

import com.redhat.reportengine.syslog.data.UdpPacket;
import com.redhat.reportengine.syslog.data.UdpPacketQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Date;
import org.apache.log4j.Logger;

public class Collector
implements Runnable {
    private static Logger _logger = Logger.getLogger(Collector.class);
    private static int serverPort;
    private static int packetSize;
    private static DatagramSocket socket;

    public Collector() {
    }

    public Collector(int serverPort, int pocketSize) {
        Collector.serverPort = serverPort;
        packetSize = pocketSize;
    }

    public static void collectMessage() throws IOException {
        socket = new DatagramSocket(serverPort);
        while (true) {
            DatagramPacket packet = new DatagramPacket(new byte[packetSize], packetSize);
            packet.setLength(packetSize);
            socket.receive(packet);
            UdpPacketQueue.addPacket(new UdpPacket(packet, new Date().getTime()));
        }
    }

    public static void stop() {
        socket.close();
    }

    public void run() {
        try {
            Collector.collectMessage();
        }
        catch (IOException ex) {
            _logger.error((Object)"Failed to start the collector,", (Throwable)ex);
        }
    }
}

