/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.queue.actions;

import com.redhat.reportengine.server.queue.actions.InsertUpdateTestLogs;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ManageQueues {
    private static final Logger _logger = Logger.getLogger(ManageQueues.class);
    private static LinkedList<Thread> threads = new LinkedList();

    public static void startAllQueueManagers() {
        threads.addLast(new Thread(new InsertUpdateTestLogs()));
        for (Thread thread : threads) {
            thread.start();
        }
    }

    private static boolean isAnyRunningThreadAvailable() {
        for (Thread thread : threads) {
            if (thread.isAlive()) {
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                _logger.error((Object)"Error on thread sleep, ", (Throwable)ex);
            }
        }
        return false;
    }

    public static void stopAllQueueManagers() {
        InsertUpdateTestLogs.setStopMe(true);
        while (ManageQueues.isAnyRunningThreadAvailable()) {
        }
    }

    public static void stopAllQueueManagersImmediate() {
        InsertUpdateTestLogs.setStopMeImmeditate(true);
        while (ManageQueues.isAnyRunningThreadAvailable()) {
        }
    }
}

