/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.email;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class SendEmail {
    private static Logger _logger = Logger.getLogger(SendEmail.class);

    public void sendEmail(String emailTo, String emailCc, String emailFrom, String mailSub, String bodyMsg, String serverName, String port) throws Exception {
        int i;
        InternetAddress[] emailToAdd = null;
        InternetAddress[] emailCcAdd = null;
        if (emailTo != null && emailTo.length() > 0) {
            String[] tmpTo = emailTo.split(",");
            emailTo = "";
            for (i = 0; i < tmpTo.length; ++i) {
                if (tmpTo[i].length() > 1) {
                    if (i == 0) {
                        emailTo = emailTo + tmpTo[i].trim();
                        continue;
                    }
                    emailTo = emailTo + "," + tmpTo[i].trim();
                    continue;
                }
                _logger.debug((Object)("Short Email Id: " + tmpTo[i]));
            }
            tmpTo = emailTo.split(",");
            emailToAdd = new InternetAddress[tmpTo.length];
            for (i = 0; i < tmpTo.length; ++i) {
                emailToAdd[i] = new InternetAddress(tmpTo[i].trim());
            }
        }
        if (emailCc != null && emailCc.length() > 0) {
            String[] tmpCc = emailCc.split(",");
            emailCc = "";
            for (i = 0; i < tmpCc.length; ++i) {
                if (tmpCc[i].length() > 1) {
                    if (i == 0) {
                        emailCc = emailCc + tmpCc[i].trim();
                        continue;
                    }
                    emailCc = emailCc + "," + tmpCc[i].trim();
                    continue;
                }
                _logger.debug((Object)("Short Email Id: " + tmpCc[i]));
            }
            tmpCc = emailCc.split(",");
            emailCcAdd = new InternetAddress[tmpCc.length];
            for (i = 0; i < tmpCc.length; ++i) {
                emailCcAdd[i] = new InternetAddress(tmpCc[i].trim());
            }
        }
        emailFrom = emailFrom.trim();
        _logger.debug((Object)("Mail Server: " + serverName + "\nEMail From: " + emailFrom + "\nEMail To: " + emailTo + "\nEMail Cc: " + emailCc + "Subject: " + mailSub + "\nMessage: " + bodyMsg));
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.host", serverName);
        if (port != null) {
            props.setProperty("mail.smtp.port", port);
        }
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        mailSession.setDebug(true);
        Transport transport = mailSession.getTransport();
        MimeMessage message = new MimeMessage(mailSession);
        message.setSubject(mailSub);
        message.setFrom((Address)new InternetAddress(emailFrom));
        message.setContent((Object)bodyMsg, "text/html");
        if (emailTo != null) {
            message.addRecipients(Message.RecipientType.TO, (Address[])emailToAdd);
        }
        if (emailCc != null) {
            message.addRecipients(Message.RecipientType.CC, (Address[])emailCcAdd);
        }
        if (emailCc == null && emailTo == null) {
            _logger.error((Object)"Unable to send the email. Reason - To and Cc are null");
        } else {
            transport.connect();
            Transport.send((Message)message);
            transport.close();
            _logger.debug((Object)"Email Sent successfully");
        }
    }
}

