/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.server.restapi.testresult;

import com.redhat.reportengine.server.api.TestResult;
import com.redhat.reportengine.server.api.TestResultException;
import com.redhat.reportengine.server.dbmap.TestCase;
import com.redhat.reportengine.server.dbmap.TestGroup;
import com.redhat.reportengine.server.dbmap.TestLogs;
import com.redhat.reportengine.server.dbmap.TestSuite;
import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/testresults")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class TestResultsREST {
    @GET
    @Path(value="/servertime")
    public String getServerTime() {
        return new SimpleDateFormat("dd-MMM-yyyy, HH:mm:ss.S, z").format(new TestResult().getServerTime());
    }

    @POST
    @Path(value="/testsuite")
    public void insertTestSuite(TestSuite testSuite) throws TestResultException {
        new TestResult().insertTestSuite(testSuite);
    }

    @PUT
    @Path(value="/testsuitename")
    public void updateTestSuiteName(TestSuite testSuite) throws TestResultException {
        new TestResult().updateTestSuiteName(testSuite);
    }

    @PUT
    @Path(value="/testsuite")
    public void updateTestSuite(TestSuite testSuite) throws TestResultException {
        new TestResult().updateTestSuite(testSuite);
    }

    @GET
    @Path(value="/testsuiteid")
    public String getTestSuiteNextAvailableId() throws TestResultException {
        return new Integer(new TestResult().getTestSuiteNextAvailableId()).toString();
    }

    @GET
    @Path(value="/testsuite/{id}")
    public TestSuite getTestSuite(@PathParam(value="id") int id) throws TestResultException {
        return new TestResult().getTestSuite(id);
    }

    @POST
    @Path(value="/testsuitebysuite")
    public TestSuite getTestSuite(TestSuite testSuite) throws TestResultException {
        return new TestResult().getTestSuite(testSuite);
    }

    @POST
    @Path(value="/testgroup")
    public TestGroup insertTestGroup(TestGroup testGroup) throws TestResultException {
        return new TestResult().insertTestGroup(testGroup);
    }

    @POST
    @Path(value="/testcase")
    public TestCase insertTestCase(TestCase testCase) throws TestResultException {
        testCase.setId(new TestResult().insertTestCase(testCase));
        return testCase;
    }

    @PUT
    @Path(value="/testcase")
    public void updateTestCase(TestCase testCase) throws TestResultException, IOException {
        new TestResult().updateTestCase(testCase);
    }

    @POST
    @Path(value="/testlog")
    public void insertTestLog(TestLogs testLogs) throws TestResultException {
        new TestResult().insertTestLog(testLogs);
    }
}

