/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.ClientCommon;
import com.redhat.reportengine.client.LogHandler;
import com.redhat.reportengine.client.RESTClientRestEasy;
import com.redhat.reportengine.server.dbmap.TestCase;
import com.redhat.reportengine.server.dbmap.TestGroup;
import com.redhat.reportengine.server.dbmap.TestLogs;
import com.redhat.reportengine.server.dbmap.TestSuite;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class RemoteAPI {
    protected static final Logger _logger = Logger.getLogger(RemoteAPI.class.getName());
    ClientCommon test = new ClientCommon();
    protected static boolean initialized = false;
    private static boolean clientConfigurationSuccess = false;
    private static boolean clientLoadedSuccess = false;
    private static final String rePropertyFile = "REPORT_ENGINE_PROPERTY_FILE";
    private static final String originalFile = "ORIGINAL.FILE";
    private static final String remoteServer = "REPORT.ENGINE.SERVER";
    private static final String rmiPort = "REPORT.ENGINE.RMI.PORT";
    private static final String testReference = "REPORT.ENGINE.TEST.REFERENCE";
    private static final String screenShot = "REPORT.ENGINE.TAKE.SCREEN.SHOT";
    private static final String buildVersion = "REPORT.ENGINE.TEST.BUILD.VERSION.REFF";
    private static final String watchLogger = "REPORT.ENGINE.WATCH.LOGGER";
    private static final String loggerType = "REPORT.RENGINE.LOGGER.TYPE";
    private static final String logLevel = "REPORT.ENGINE.LOGGER.LEVEL";
    private static final String serverRESTUrl = "REPORT.ENGINE.SERVER.REST.URL";
    private static final String testSuiteName = "TEST.SUITE.NAME";
    protected static final String loggersToWarn = "sun.rmi,org.apache.http,com.sun.xml.bind,com.sun.jersey";
    private RESTClientRestEasy restClient = null;

    public boolean isLastTestStateRunning() {
        return this.test.getTestCaseId() != null;
    }

    public String getBuildVersionReference() {
        return this.test.getBuildVersionReference();
    }

    public Date getServerTime() throws Exception {
        return new SimpleDateFormat("dd-MMM-yyyy, HH:mm:ss.S, z").parse((String)this.restClient.get("/servertime", String.class));
    }

    private void setAllVariables() {
        try {
            Properties propertyFile = new Properties();
            String primaryPropertyFile = null;
            _logger.log(Level.INFO, "System.getenv: " + System.getenv(rePropertyFile));
            _logger.log(Level.INFO, "System.getProperty: " + System.getProperty(rePropertyFile));
            if (System.getenv(rePropertyFile) != null) {
                primaryPropertyFile = System.getenv(rePropertyFile).trim();
            } else if (System.getProperty(rePropertyFile) != null) {
                primaryPropertyFile = System.getProperty(rePropertyFile).trim();
            } else {
                CodeSource codeSource = RemoteAPI.class.getProtectionDomain().getCodeSource();
                File jarFile = new File(codeSource.getLocation().toURI().getPath());
                File jarDir = jarFile.getParentFile();
                if (jarDir != null && jarDir.isDirectory()) {
                    primaryPropertyFile = jarDir + "/ReportEngineClient.properties";
                }
            }
            _logger.log(Level.INFO, "Properties File: " + primaryPropertyFile);
            if (primaryPropertyFile != null) {
                propertyFile.load(new FileReader(primaryPropertyFile));
            } else {
                this.setClientConfigurationSuccess(false);
                _logger.log(Level.WARNING, "Could not find report engine properties File any where, Please update property file by atleast one of the way, Disabled Report Engine logs!!");
            }
            if (propertyFile.getProperty(originalFile) != null && propertyFile.getProperty(originalFile).trim().length() > 0) {
                String newPropertyFile = propertyFile.getProperty(originalFile).trim();
                _logger.log(Level.INFO, "Properties File(New): ORIGINAL.FILE");
                propertyFile.clear();
                propertyFile.load(new FileReader(newPropertyFile));
            }
            this.test.setServerRestUrl(propertyFile.getProperty(serverRESTUrl).trim());
            this.test.setServerIp(propertyFile.getProperty(remoteServer).trim());
            this.test.setServerRMIPort(propertyFile.getProperty(rmiPort).trim());
            this.test.setTestReference(propertyFile.getProperty(testReference).trim());
            this.test.setTakeScreenShot(Boolean.parseBoolean(propertyFile.getProperty(screenShot).trim()));
            this.test.setLoggerEnabled(Boolean.parseBoolean(propertyFile.getProperty(watchLogger).trim()));
            this.test.setLoggerType(propertyFile.getProperty(loggerType).trim());
            this.test.setLogLevel(propertyFile.getProperty(logLevel).trim());
            this.test.setBuildVersionReference(propertyFile.getProperty(buildVersion).trim());
            if (propertyFile.getProperty(testSuiteName) != null && propertyFile.getProperty(testSuiteName).trim().length() > 0) {
                this.test.setTestSuiteName(propertyFile.getProperty(testSuiteName));
            }
            this.setClientConfigurationSuccess(true);
        }
        catch (Exception ex) {
            this.setClientConfigurationSuccess(false);
            ex.printStackTrace();
        }
    }

    public void initClient(String testSuiteName) throws Exception {
        this.restClient = new RESTClientRestEasy();
        this.initClient(testSuiteName, null);
    }

    public void initClient(String testSuiteName, String comments) throws Exception {
        if (!initialized) {
            this.doInitialize(testSuiteName, comments);
            if (this.isClientConfigurationSuccess()) {
                this.runLogHandler();
            }
            initialized = true;
        }
    }

    protected void setLoggers(String loggers, Level level) {
        for (String logger : loggers.split(",")) {
            Logger.getLogger(logger.trim()).setLevel(level);
        }
        _logger.log(Level.INFO, "[sun.rmi,org.apache.http,com.sun.xml.bind,com.sun.jersey] loggers log level set to " + level.toString());
    }

    public void runLogHandler() {
        if (this.test.isLoggerEnabled()) {
            LogHandler.setRemoteApi(this);
            LogHandler.initLogger();
            _logger.log(Level.INFO, "Enabled Watch Logger, Logger Type: " + this.test.getLoggerType());
        } else {
            this.setLoggers(loggersToWarn, Level.WARNING);
        }
    }

    private void doInitialize(String testSuiteName, String comments) throws Exception {
        this.setAllVariables();
        if (this.isClientConfigurationSuccess()) {
            this.restClient.setServerUrl(this.test.getServerRestUrl());
            this.restClient.setRootUrl("/testresults");
            _logger.log(Level.INFO, "Report Engine Server REST URL: " + this.test.getServerRestUrl());
            _logger.log(Level.INFO, "Report Engine Server Time: " + this.getServerTime());
            this.insertTestSuite(testSuiteName, comments);
            _logger.log(Level.INFO, "Report Engine Client Loaded successfully...");
            RemoteAPI.setClientLoadedSuccess(true);
        } else {
            _logger.log(Level.WARNING, "Report Engine Client Failed to Load..");
        }
    }

    public void insertTestSuite(String TestSuitName) throws Exception {
        this.insertTestSuite(TestSuitName, null);
    }

    public void insertTestSuite(String TestSuitName, String comments) throws Exception {
        this.test.setTestSuiteId(Integer.valueOf((String)this.restClient.get("/testsuiteid", String.class)));
        TestSuite testSuite = new TestSuite();
        testSuite.setId(this.test.getTestSuiteId());
        testSuite.setRemoteStartTime(new Date());
        testSuite.setTestComments(comments);
        testSuite.setTestStatus("Running");
        if (this.test.getTestSuiteName() != null) {
            testSuite.setTestSuiteName(this.test.getTestSuiteName());
        } else {
            testSuite.setTestSuiteName(TestSuitName);
        }
        testSuite.setTestReference(this.test.getTestReference());
        testSuite.setTestHost(InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "]");
        this.restClient.post("/testsuite", testSuite, TestSuite.class);
    }

    public void updateTestSuiteName(String testSuiteName) throws Exception {
        this.updateTestSuiteName(testSuiteName, null);
    }

    public void updateTestSuiteName(String testSuiteName, String comments) throws Exception {
        TestSuite testSuite = new TestSuite();
        testSuite.setId(this.test.getTestSuiteId());
        if (this.test.getTestSuiteName() != null) {
            testSuite.setTestSuiteName(this.test.getTestSuiteName());
        } else {
            testSuite.setTestSuiteName(testSuiteName);
        }
        testSuite.setTestComments(comments);
        this.restClient.put("/testsuitename", testSuite, TestSuite.class);
    }

    public void updateTestSuite(String status, String build) throws Exception {
        this.updateTestSuite(status, build, null);
    }

    public void updateTestSuite(String status, String build, String comments) throws Exception {
        TestSuite testSuite = new TestSuite();
        testSuite.setId(this.test.getTestSuiteId());
        testSuite.setTestStatus(status);
        testSuite.setTestBuild(build);
        testSuite.setTestComments(comments);
        testSuite.setRemoteEndTime(new Date());
        this.restClient.put("/testsuite", testSuite, TestSuite.class);
    }

    public void insertTestGroup(String groupName) throws Exception {
        if (!this.test.getTestGroupName().equals(groupName)) {
            TestGroup testGroup = new TestGroup();
            testGroup.setTestSuiteId(this.test.getTestSuiteId());
            testGroup.setTestGroup(groupName);
            testGroup.setRemoteTime(new Date());
            testGroup = (TestGroup)this.restClient.post("/testgroup", testGroup, TestGroup.class);
            this.test.setTestGroupId(testGroup.getId());
            this.test.setTestGroupName(groupName);
        }
    }

    public void insertTestCase(String testCaseName, String result) throws Exception {
        this.insertTestCase(testCaseName, null, result);
    }

    public void insertTestCase(String testCaseName, String arguments, String result) throws Exception {
        TestCase testCase = new TestCase();
        testCase.setTestSuiteId(this.test.getTestSuiteId());
        testCase.setTestGroupId(this.test.getTestGroupId());
        testCase.setTestName(testCaseName);
        testCase.setTestArguments(arguments);
        testCase.setTestResult(result);
        testCase.setRemoteStartTime(new Date());
        this.test.setTestCaseId(((TestCase)this.restClient.post("/testcase", testCase, TestCase.class)).getId());
        this.test.setScreenShotFileName(null);
        if (!result.equalsIgnoreCase("Running")) {
            this.test.setTestCaseId(null);
        }
    }

    public void updateTestCase(String status) throws Exception {
        this.updateTestCase(status, null);
    }

    public void updateTestCase(String status, String comments) throws Exception {
        TestCase testCase = new TestCase();
        testCase.setId(this.test.getTestCaseId());
        testCase.setTestResult(status);
        if (comments != null) {
            testCase.setTestComments(comments);
        }
        if (this.test.getScreenShotFileName() != null) {
            testCase.setScreenShotFileName(this.test.getScreenShotFileName());
            testCase.setScreenShotFileBase64(this.test.getScreenShotFileBase64String());
        }
        testCase.setRemoteEndTime(new Date());
        this.restClient.put("/testcase", testCase, TestCase.class);
        if (!status.equalsIgnoreCase("Running")) {
            this.test.setTestCaseId(null);
        }
    }

    public void takeScreenShot() {
        if (!this.test.isTakeScreenShot()) {
            return;
        }
        try {
            _logger.log(Level.FINE, "Taking screen shot...");
            String fileName = "ScreenShot_" + new SimpleDateFormat("dd_MMM_yyyy_hh_mm_ssaa").format(new Date()) + ".png";
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle screenRectangle = new Rectangle(screenSize);
            Robot robot = new Robot();
            BufferedImage image = robot.createScreenCapture(screenRectangle);
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", byteArrayStream);
            byteArrayStream.flush();
            byte[] imageAsRawBytes = byteArrayStream.toByteArray();
            byteArrayStream.close();
            this.test.setScreenShotFileBase64String(new String(Base64.encodeBase64((byte[])imageAsRawBytes)));
            _logger.log(Level.FINE, "ScreenShot File name: {0}, Screen shot done", fileName);
            this.test.setScreenShotFileName(fileName);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "Unable to take screen shot,", ex);
        }
    }

    public void insertLogMessage(TestLogs testLogs) throws Exception {
        testLogs.setTestSuiteId(this.test.getTestSuiteId());
        if (this.test.getTestGroupId() != null) {
            testLogs.setTestGroupId(this.test.getTestGroupId());
        }
        if (this.test.getTestCaseId() != null) {
            testLogs.setTestCaseId(this.test.getTestCaseId());
        }
        this.restClient.post("/testlog", testLogs, TestLogs.class);
    }

    public String getLoggerType() {
        return this.test.getLoggerType();
    }

    public String getLogLevel() {
        return this.test.getLogLevel();
    }

    public boolean isClientConfigurationSuccess() {
        return clientConfigurationSuccess;
    }

    public void setClientConfigurationSuccess(boolean clientConfigurationSuccess) {
        RemoteAPI.clientConfigurationSuccess = clientConfigurationSuccess;
    }

    public static boolean isClientLoadedSuccess() {
        return clientLoadedSuccess;
    }

    public static void setClientLoadedSuccess(boolean clientLoadedSuccess) {
        RemoteAPI.clientLoadedSuccess = clientLoadedSuccess;
    }
}

