/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.ClientCommon;
import com.redhat.reportengine.client.LogHandler;
import com.redhat.reportengine.client.RESTClientRestEasy;
import com.redhat.reportengine.server.dbmap.TestCase;
import com.redhat.reportengine.server.dbmap.TestGroup;
import com.redhat.reportengine.server.dbmap.TestLogs;
import com.redhat.reportengine.server.dbmap.TestSuite;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.net.InetAddress;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class RemoteAPI {
    private static Logger sunLogger = Logger.getLogger("sun.rmi");
    ClientCommon test = new ClientCommon();
    protected static boolean initialized = false;
    private boolean clientConfigurationSuccess = false;
    private static final String rePropertyFile = "REPORT_ENGINE_PROPERTY_FILE";
    private static final String originalFile = "ORIGINAL.FILE";
    private static final String remoteServer = "REPORT.ENGINE.SERVER";
    private static final String rmiPort = "REPORT.ENGINE.RMI.PORT";
    private static final String testReference = "REPORT.ENGINE.TEST.REFERENCE";
    private static final String clientTempLocation = "REPORT.ENGINE.CLIENT.TEMP";
    private static final String screenShot = "REPORT.ENGINE.TAKE.SCREEN.SHOT";
    private static final String buildVersion = "REPORT.ENGINE.TEST.BUILD.VERSION.REFF";
    private static final String watchLogger = "REPORT.ENGINE.WATCH.LOGGER";
    private static final String loggerType = "REPORT.RENGINE.LOGGER.TYPE";
    private static final String logLevel = "REPORT.ENGINE.LOGGER.LEVEL";
    private RESTClientRestEasy restClient = null;

    public boolean isLastTestStateRunning() {
        return this.test.getTestCaseId() != null;
    }

    public String getBuildVersionReference() {
        return this.test.getBuildVersionReference();
    }

    public Date getServerTime() throws Exception {
        return new SimpleDateFormat("dd-MMM-yyyy, HH:mm:ss.S, z").parse((String)this.restClient.get("/servertime", String.class));
    }

    private void setAllVariables() {
        try {
            Properties propertyFile = new Properties();
            String primaryPropertyFile = null;
            System.out.println("Report Engine Client: Properties File: System.getenv: " + System.getenv(rePropertyFile));
            System.out.println("Report Engine Client: Properties File: System.getProperty: " + System.getProperty(rePropertyFile));
            if (System.getenv(rePropertyFile) != null) {
                primaryPropertyFile = System.getenv(rePropertyFile).trim();
            } else if (System.getProperty(rePropertyFile) != null) {
                primaryPropertyFile = System.getProperty(rePropertyFile).trim();
            } else {
                CodeSource codeSource = RemoteAPI.class.getProtectionDomain().getCodeSource();
                File jarFile = new File(codeSource.getLocation().toURI().getPath());
                File jarDir = jarFile.getParentFile();
                if (jarDir != null && jarDir.isDirectory()) {
                    primaryPropertyFile = jarDir + "/ReportEngineClient.properties";
                }
            }
            System.out.println("Report Engine Client: Properties File: " + primaryPropertyFile);
            if (primaryPropertyFile != null) {
                propertyFile.load(new FileReader(primaryPropertyFile));
            } else {
                this.setClientConfigurationSuccess(false);
                System.out.println("Report Engine Client: Could not find report engine properties File any where, Please update property file by atleast one of the way, Disabled Report Engine logs!!");
            }
            if (propertyFile.getProperty(originalFile) != null && propertyFile.getProperty(originalFile).trim().length() > 0) {
                String newPropertyFile = propertyFile.getProperty(originalFile).trim();
                System.out.println("Report Engine Client: Properties File(New): ORIGINAL.FILE");
                propertyFile.clear();
                propertyFile.load(new FileReader(newPropertyFile));
            }
            if (System.getProperty(remoteServer) != null) {
                this.test.setServerIp(System.getProperty(remoteServer).trim());
            } else {
                this.test.setServerIp(propertyFile.getProperty(remoteServer).trim());
            }
            if (System.getProperty(rmiPort) != null) {
                this.test.setServerRMIPort(System.getProperty(rmiPort).trim());
            } else {
                this.test.setServerRMIPort(propertyFile.getProperty(rmiPort).trim());
            }
            if (System.getProperty(testReference) != null) {
                this.test.setTestReference(System.getProperty(testReference).trim());
            } else {
                this.test.setTestReference(propertyFile.getProperty(testReference).trim());
            }
            if (System.getProperty(clientTempLocation) != null) {
                this.test.setClientTempLocation(System.getProperty(clientTempLocation).trim());
            } else {
                this.test.setClientTempLocation(propertyFile.getProperty(clientTempLocation).trim());
            }
            if (System.getProperty(screenShot) != null) {
                if (System.getProperty(screenShot).trim().equalsIgnoreCase("TRUE")) {
                    this.test.setTakeScreenShot(true);
                } else {
                    this.test.setTakeScreenShot(false);
                }
            } else if (propertyFile.getProperty(screenShot).trim().equalsIgnoreCase("TRUE")) {
                this.test.setTakeScreenShot(true);
            } else {
                this.test.setTakeScreenShot(false);
            }
            if (System.getProperty(watchLogger) != null) {
                if (System.getProperty(watchLogger).trim().equalsIgnoreCase("TRUE")) {
                    this.test.setLoggerEnabled(true);
                } else {
                    this.test.setLoggerEnabled(false);
                }
            } else if (propertyFile.getProperty(watchLogger).trim().equalsIgnoreCase("TRUE")) {
                this.test.setLoggerEnabled(true);
            } else {
                this.test.setLoggerEnabled(false);
            }
            if (System.getProperty(loggerType) != null) {
                this.test.setLoggerType(System.getProperty(loggerType).trim());
            } else {
                this.test.setLoggerType(propertyFile.getProperty(loggerType).trim());
            }
            if (System.getProperty(logLevel) != null) {
                this.test.setLogLevel(System.getProperty(logLevel).trim());
            } else {
                this.test.setLogLevel(propertyFile.getProperty(logLevel).trim());
            }
            if (System.getProperty(buildVersion) != null) {
                this.test.setBuildVersionReference(System.getProperty(buildVersion).trim());
            } else {
                this.test.setBuildVersionReference(propertyFile.getProperty(buildVersion).trim());
            }
            this.setClientConfigurationSuccess(true);
        }
        catch (Exception ex) {
            this.setClientConfigurationSuccess(false);
            ex.printStackTrace();
        }
    }

    public void initClient(String testSuiteName) throws Exception {
        this.restClient = new RESTClientRestEasy();
        this.initClient(testSuiteName, null);
    }

    public void initClient(String testSuiteName, String comments) throws Exception {
        if (!initialized) {
            this.doInitialize(testSuiteName, comments);
            if (this.isClientConfigurationSuccess()) {
                this.runLogHandler();
            }
            initialized = true;
        }
    }

    public void runLogHandler() {
        if (this.test.isLoggerEnabled()) {
            LogHandler.setRemoteApi(this);
            LogHandler.initLogger();
            System.out.println("Report Engine Client: Enabled Watch Logger, Logger Type: " + this.test.getLoggerType());
        }
        sunLogger.setLevel(Level.WARNING);
        System.out.println("Report Engine Client: sun.rmi log level set to WARNING");
    }

    private void doInitialize(String testSuiteName, String comments) throws Exception {
        this.setAllVariables();
        if (this.isClientConfigurationSuccess()) {
            this.restClient.setServerUrl("https://mercury.lab.eng.pnq.redhat.com:8080/re/resteasy");
            this.restClient.setRootUrl("/testresults");
            System.out.println("Report Engine Client: Report Engine Server URL: //" + this.test.getServerIp() + ":" + this.test.getServerRMIPort() + "/" + "CLIENT_RMI_PACK");
            this.insertTestSuite(testSuiteName, comments);
            System.out.println("Report Engine Client: Report Engine Client Loaded successfully");
        } else {
            System.out.println("Report Engine Client: Report Engine Client Failed to Load!!");
        }
    }

    public void insertTestSuite(String TestSuitName) throws Exception {
        this.insertTestSuite(TestSuitName, null);
    }

    public void insertTestSuite(String TestSuitName, String comments) throws Exception {
        this.test.setTestSuiteId(Integer.valueOf((String)this.restClient.get("/testsuiteid", String.class)));
        TestSuite testSuite = new TestSuite();
        testSuite.setId(this.test.getTestSuiteId());
        testSuite.setRemoteStartTime(new Date());
        testSuite.setTestComments(comments);
        testSuite.setTestStatus("Running");
        testSuite.setTestSuiteName(TestSuitName);
        testSuite.setTestReference(this.test.getTestReference());
        testSuite.setTestHost(InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "]");
        this.restClient.post("/testsuite", testSuite, TestSuite.class);
    }

    public void updateTestSuiteName(String testSuiteName) throws Exception {
        this.updateTestSuiteName(testSuiteName, null);
    }

    public void updateTestSuiteName(String testSuiteName, String comments) throws Exception {
        TestSuite testSuite = new TestSuite();
        testSuite.setId(this.test.getTestSuiteId());
        testSuite.setTestSuiteName(testSuiteName);
        testSuite.setTestComments(comments);
        this.restClient.put("/testsuitename", testSuite, TestSuite.class);
    }

    public void updateTestSuite(String status, String build) throws Exception {
        this.updateTestSuite(status, build, null);
    }

    public void updateTestSuite(String status, String build, String comments) throws Exception {
        TestSuite testSuite = new TestSuite();
        testSuite.setId(this.test.getTestSuiteId());
        testSuite.setTestStatus(status);
        testSuite.setTestBuild(build);
        testSuite.setTestComments(comments);
        testSuite.setRemoteEndTime(new Date());
        this.restClient.put("/testsuite", testSuite, TestSuite.class);
    }

    public void insertTestGroup(String groupName) throws Exception {
        if (!this.test.getTestGroupName().equals(groupName)) {
            TestGroup testGroup = new TestGroup();
            testGroup.setTestSuiteId(this.test.getTestSuiteId());
            testGroup.setTestGroup(groupName);
            testGroup.setRemoteTime(new Date());
            testGroup = (TestGroup)this.restClient.post("/testgroup", testGroup, TestSuite.class);
            this.test.setTestGroupId(testGroup.getId());
            this.test.setTestGroupName(groupName);
        }
    }

    public void insertTestCase(String testCaseName, String result) throws Exception {
        this.insertTestCase(testCaseName, null, result);
    }

    public void insertTestCase(String testCaseName, String arguments, String result) throws Exception {
        TestCase testCase = new TestCase();
        testCase.setTestSuiteId(this.test.getTestSuiteId());
        testCase.setTestGroupId(this.test.getTestGroupId());
        testCase.setTestName(testCaseName);
        testCase.setTestArguments(arguments);
        testCase.setTestResult(result);
        testCase.setRemoteStartTime(new Date());
        this.test.setTestCaseId((Integer)this.restClient.post("/testcase", testCase, TestCase.class));
        this.test.setScreenShotFileName(null);
        if (!result.equalsIgnoreCase("Running")) {
            this.test.setTestCaseId(null);
        }
    }

    public void updateTestCase(String status) throws Exception {
        this.updateTestCase(status, null, null);
    }

    public void updateTestCase(String status, String comments) throws Exception {
        this.updateTestCase(status, comments, null);
    }

    public void updateTestCase(String status, String comments, String screenShotFileName) throws Exception {
        TestCase testCase = new TestCase();
        testCase.setId(this.test.getTestCaseId());
        testCase.setTestResult(status);
        if (comments != null) {
            testCase.setTestComments(comments);
        }
        if (screenShotFileName != null) {
            this.test.setScreenShotFileName(screenShotFileName);
        }
        if (this.test.getScreenShotFileName() != null) {
            File screenShot = new File(this.test.getScreenShotFileName());
            testCase.setScreenShotFileName(screenShot.getName());
            byte[] screenShotByte = new byte[(int)screenShot.length()];
            FileInputStream in = new FileInputStream(screenShot);
            in.read(screenShotByte);
            in.close();
            testCase.setScreenShotFileBase64(new String(Base64.encodeBase64((byte[])screenShotByte)));
            System.out.println("Report Engine Client: Screen Shot File Name (Sent): " + testCase.getScreenShotFileName());
            if (!screenShot.delete()) {
                System.out.println("Report Engine Client: Failed to delete the file: " + testCase.getScreenShotFileName());
            }
        }
        testCase.setRemoteEndTime(new Date());
        this.restClient.put("/testcase", testCase, TestCase.class);
        if (!status.equalsIgnoreCase("Running")) {
            this.test.setTestCaseId(null);
        }
    }

    public void takeScreenShot() {
        if (!this.test.isTakeScreenShot()) {
            return;
        }
        try {
            System.out.println("Report Engine Client: Taking screen shot...");
            if (new File(this.test.getClientTempLocation()).mkdirs()) {
                System.out.println("Report Engine Client: Directory Created... : " + this.test.getClientTempLocation());
            } else {
                System.out.println("Report Engine Client: Directory might be available: " + this.test.getClientTempLocation());
            }
            String fileName = "ScreenShot_" + new SimpleDateFormat("dd_MMM_yyyy_hh_mm_ssaa").format(new Date()) + ".png";
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle screenRectangle = new Rectangle(screenSize);
            Robot robot = new Robot();
            BufferedImage image = robot.createScreenCapture(screenRectangle);
            System.out.println("Report Engine Client: ScreenShot File name: " + this.test.getClientTempLocation() + fileName);
            ImageIO.write((RenderedImage)image, "png", new File(this.test.getClientTempLocation() + fileName));
            System.out.println("Report Engine Client: Screen shot done!!");
            this.test.setScreenShotFileName(this.test.getClientTempLocation() + fileName);
        }
        catch (Exception ex) {
            System.out.println("Report Engine Client: Unable to take screen shot,");
            ex.printStackTrace();
        }
    }

    public void insertLogMessage(TestLogs testLogs) throws Exception {
        testLogs.setTestSuiteId(this.test.getTestSuiteId());
        if (this.test.getTestGroupId() != null) {
            testLogs.setTestGroupId(this.test.getTestGroupId());
        }
        if (this.test.getTestCaseId() != null) {
            testLogs.setTestCaseId(this.test.getTestCaseId());
        }
        this.restClient.post("/testcase", testLogs, TestLogs.class);
    }

    public String getLoggerType() {
        return this.test.getLoggerType();
    }

    public String getLogLevel() {
        return this.test.getLogLevel();
    }

    public boolean isClientConfigurationSuccess() {
        return this.clientConfigurationSuccess;
    }

    public void setClientConfigurationSuccess(boolean clientConfigurationSuccess) {
        this.clientConfigurationSuccess = clientConfigurationSuccess;
    }
}

