/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.ClientCommon;
import com.redhat.reportengine.client.RemoteAPI;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.internal.IResultListener;

public class ReportEngineClientTestNGListener
implements IResultListener,
ISuiteListener {
    protected static Logger _logger = Logger.getLogger(ReportEngineClientTestNGListener.class.getName());

    public ReportEngineClientTestNGListener(boolean donothing) {
    }

    public ReportEngineClientTestNGListener() {
        try {
            RemoteAPI.getRemoteApi().initClient(InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "]");
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "Report Engine Client Failed to start!!", ex);
        }
    }

    protected RemoteAPI getRemoteApi() {
        return RemoteAPI.getRemoteApi();
    }

    public String getParametersString(Object[] parameters) {
        String parametersString = "";
        if (parameters != null && parameters.length > 0) {
            parametersString = Arrays.deepToString(parameters);
        }
        return parametersString;
    }

    public void onFinish(ITestContext context) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            // empty if block
        }
    }

    public void onStart(ITestContext context) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().insertTestGroup(context.getName());
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onStart,", ex);
            }
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult arg0) {
    }

    public void onTestFailure(ITestResult result) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().takeScreenShot();
                this.getRemoteApi().updateTestCase("Failed", ClientCommon.toString(result.getThrowable()));
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onTestFailure,", ex);
            }
        }
    }

    public void onTestSkipped(ITestResult result) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                if (this.getRemoteApi().isLastTestStateRunning()) {
                    this.getRemoteApi().updateTestCase("Skipped");
                } else {
                    this.getRemoteApi().insertTestCase(result.getName(), result.getName() + "(" + this.getParametersString(result.getParameters()) + ")", "Skipped");
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onTestSkipped,", ex);
            }
        }
    }

    public void onTestStart(ITestResult test) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().insertTestCase(test.getName(), test.getName() + "(" + this.getParametersString(test.getParameters()) + ")", "Running");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onTestStart,", ex);
            }
        }
    }

    public void onTestSuccess(ITestResult result) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().updateTestCase("Passed");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onTestSuccess,", ex);
            }
        }
    }

    public void onConfigurationFailure(ITestResult testResult) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            if (testResult.getThrowable() == null) {
                _logger.log(Level.WARNING, "Configuration Failed!!");
            } else {
                _logger.log(Level.WARNING, "Configuration Failed!!", testResult.getThrowable());
            }
        }
    }

    public void onConfigurationSkip(ITestResult testResult) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            if (testResult.getThrowable() == null) {
                _logger.log(Level.WARNING, "Configuration Skipped!!");
            } else {
                _logger.log(Level.WARNING, "Configuration Skipped!!", testResult.getThrowable());
            }
        }
    }

    public void onConfigurationSuccess(ITestResult testResult) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            _logger.log(Level.FINE, "Configuration loadded Successfully!!");
        }
    }

    public void onFinish(ISuite suite) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().updateTestSuite("Completed", System.getProperty(this.getRemoteApi().getBuildVersionReference()));
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onFinish,", ex);
            }
            this.getRemoteApi().removeHandlers();
        }
    }

    public void onStart(ISuite suite) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().runLogHandler();
                this.getRemoteApi().updateTestSuiteName(suite.getName());
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onStart,", ex);
            }
        }
    }
}

