/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.ClientCommon;
import com.redhat.reportengine.client.RemoteAPI;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ReportEngineClientJunitListener
extends RunListener {
    protected static Logger _logger = Logger.getLogger(ReportEngineClientJunitListener.class.getName());

    public ReportEngineClientJunitListener() {
        try {
            this.getRemoteApi().initClient(InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "]");
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "Report Engine Client Failed to start!!", ex);
        }
    }

    public void testRunStarted(Description description) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            this.getRemoteApi().runLogHandler();
            try {
                if (description != null && description.getDisplayName() != null) {
                    this.getRemoteApi().updateTestSuiteName(description.getDisplayName());
                    return;
                }
                this.getRemoteApi().insertTestGroup("Junit - No groups");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testRunStarted,", ex);
            }
        }
    }

    private RemoteAPI getRemoteApi() {
        return RemoteAPI.getRemoteApi();
    }

    public void testRunFinished(Result result) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().updateTestSuite("Completed", System.getProperty(this.getRemoteApi().getBuildVersionReference()));
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testRunFinished,", ex);
            }
        }
    }

    public void testStarted(Description description) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().insertTestCase(description.getMethodName(), description.getClassName() + "." + description.getMethodName(), "Running");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testStarted,", ex);
            }
        }
    }

    public void testFinished(Description description) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().updateTestCase("Passed");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testFinished,", ex);
            }
        }
    }

    public void testFailure(Failure failure) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                this.getRemoteApi().takeScreenShot();
                this.getRemoteApi().updateTestCase("Failed", ClientCommon.toString(failure.getException()));
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testFailure,", ex);
            }
        }
    }

    public void testIgnored(Description description) {
        if (this.getRemoteApi().isClientLoadedSuccess()) {
            try {
                if (this.getRemoteApi().isLastTestStateRunning()) {
                    this.getRemoteApi().updateTestCase("Skipped");
                } else {
                    this.getRemoteApi().insertTestCase(description.getMethodName(), description.getClassName() + "." + description.getMethodName(), "Skipped");
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testIgnored,", ex);
            }
        }
    }
}

