/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.RemoteAPI;
import com.redhat.reportengine.client.ReportEngineClientTestNGListener;
import java.net.InetAddress;
import java.util.logging.Level;
import org.testng.ISuite;

public class RemoteEngineMultiInstanceClientTestNGListener
extends ReportEngineClientTestNGListener {
    private RemoteAPI remoteApi;
    private String currentSuiteFile;

    public RemoteEngineMultiInstanceClientTestNGListener() {
        super(false);
    }

    @Override
    protected RemoteAPI getRemoteApi() {
        return this.remoteApi;
    }

    @Override
    public void onStart(ISuite suite) {
        this.restartRemoteApiOnSuiteChange(suite);
        super.onStart(suite);
    }

    private void restartRemoteApiOnSuiteChange(ISuite arg0) {
        if (!arg0.getXmlSuite().getFileName().equals(this.currentSuiteFile)) {
            _logger.log(Level.WARNING, arg0.getXmlSuite().getFileName());
            this.startRemoteApi();
            this.currentSuiteFile = arg0.getXmlSuite().getFileName();
        }
    }

    private void startRemoteApi() {
        this.remoteApi = new RemoteAPI();
        try {
            _logger.log(Level.INFO, "Starting Report Engine Client");
            this.remoteApi.initClient(InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "]");
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "Report Engine Client Failed to start!!", ex);
        }
    }
}

