/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.JulReportEngineLogHandler;
import com.redhat.reportengine.client.Log4jReportEngineLogHandler;
import com.redhat.reportengine.client.RemoteAPI;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.Appender;

public class LogHandler {
    protected static RemoteAPI remoteApi;
    protected static boolean isLoadedHandler;
    protected static JulReportEngineLogHandler reportEngineJulHandler;
    protected static Log4jReportEngineLogHandler reportEngineLog4jHandler;
    private static final Logger _logger;
    public static final String LOG_LEVEL_DEFAULT = "DEFAULT";
    public static final String LOG_LEVEL_FINEST = "FINEST";
    public static final String LOG_LEVEL_FINER = "FINER";
    public static final String LOG_LEVEL_FINE = "FINE";
    public static final String LOG_LEVEL_WARNING = "WARNING";
    public static final String LOG_LEVEL_SEVERE = "SEVERE";
    public static final String LOGGER_JUL = "JUL";
    public static final String LOGGER_LOG4J = "LOG4J";

    public static void teardown() {
        LogHandler.log4jTeardown();
        LogHandler.julTeardown();
        remoteApi = null;
        isLoadedHandler = false;
        reportEngineJulHandler = null;
        reportEngineLog4jHandler = null;
    }

    private static void log4jTeardown() {
        org.apache.log4j.Logger log4jLogger = LogHandler.getLog4jLogger();
        log4jLogger.removeAppender((Appender)reportEngineLog4jHandler);
        Enumeration appenders = log4jLogger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Object appender = appenders.nextElement();
            if (appender.getClass().equals(Log4jReportEngineLogHandler.class)) {
                // empty if block
            }
            log4jLogger.removeAppender((Appender)appender);
        }
    }

    private static org.apache.log4j.Logger getLog4jLogger() {
        return org.apache.log4j.Logger.getRootLogger();
    }

    private static void julTeardown() {
        Logger julLogger = Logger.getLogger("");
        julLogger.removeHandler(reportEngineJulHandler);
        for (Handler handler : julLogger.getHandlers()) {
            if (!handler.getClass().equals(JulReportEngineLogHandler.class)) continue;
            julLogger.removeHandler(handler);
        }
    }

    public static void julLoggerSetup() {
        Logger julLogger = Logger.getLogger("");
        if (!remoteApi.getLogLevel().equalsIgnoreCase(LOG_LEVEL_DEFAULT)) {
            julLogger.setLevel(Level.parse(remoteApi.getLogLevel()));
        }
        if (isLoadedHandler) {
            julLogger.addHandler(reportEngineJulHandler);
            remoteApi.setJulLoggers("org.apache.http,com.sun.xml.bind,com.sun.jersey,org.jboss.resteasy", Level.WARNING);
            _logger.log(Level.INFO, "Report Engine Client: JUL Handler reloaded...");
        } else {
            reportEngineJulHandler = new JulReportEngineLogHandler(LogHandler.getRemoteApi());
            julLogger.addHandler(reportEngineJulHandler);
            remoteApi.setJulLoggers("org.apache.http,com.sun.xml.bind,com.sun.jersey,org.jboss.resteasy", Level.WARNING);
            _logger.log(Level.INFO, "Report Engine Client: JUL Handler added...");
            isLoadedHandler = true;
        }
        _logger.log(Level.INFO, "Report Engine Client: Log Level (JUL): " + julLogger.getLevel());
    }

    public static void log4jLoggerSetup() {
        org.apache.log4j.Logger log4jLogger = LogHandler.getLog4jLogger();
        if (!remoteApi.getLogLevel().equalsIgnoreCase(LOG_LEVEL_DEFAULT)) {
            log4jLogger.setLevel(org.apache.log4j.Level.toLevel((String)remoteApi.getLogLevel(), (org.apache.log4j.Level)org.apache.log4j.Level.INFO));
        }
        if (isLoadedHandler) {
            log4jLogger.removeAppender((Appender)reportEngineLog4jHandler);
            log4jLogger.addAppender((Appender)reportEngineLog4jHandler);
            remoteApi.setLog4jLoggers("org.apache.http,com.sun.xml.bind,com.sun.jersey,org.jboss.resteasy", org.apache.log4j.Level.WARN);
            _logger.log(Level.INFO, "Report Engine Client: LOG4J Handler reloaded...");
        } else {
            reportEngineLog4jHandler = new Log4jReportEngineLogHandler(LogHandler.getRemoteApi());
            log4jLogger.addAppender((Appender)reportEngineLog4jHandler);
            remoteApi.setLog4jLoggers("org.apache.http,com.sun.xml.bind,com.sun.jersey,org.jboss.resteasy", org.apache.log4j.Level.WARN);
            _logger.log(Level.INFO, "Report Engine Client: LOG4J Handler added...");
            isLoadedHandler = true;
        }
        _logger.log(Level.INFO, "Report Engine Client: Log Level (log4j): " + log4jLogger.getLevel());
    }

    public static RemoteAPI getRemoteApi() {
        return remoteApi;
    }

    public static void setRemoteApi(RemoteAPI remoteApi) {
        LogHandler.remoteApi = remoteApi;
    }

    public static void initLogger() {
        if (remoteApi.getLoggerType().equalsIgnoreCase(LOGGER_JUL)) {
            LogHandler.julLoggerSetup();
        } else if (remoteApi.getLoggerType().equalsIgnoreCase(LOGGER_LOG4J)) {
            LogHandler.log4jLoggerSetup();
        } else {
            _logger.log(Level.WARNING, "Report Engine Client: Un-supported Logger Type: " + remoteApi.getLoggerType());
        }
    }

    static {
        isLoadedHandler = false;
        reportEngineJulHandler = null;
        reportEngineLog4jHandler = null;
        _logger = Logger.getLogger(LogHandler.class.getName());
    }
}

