/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.ClientCommon;
import com.redhat.reportengine.client.RemoteAPI;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ReportEngineClientJunitListener
extends RunListener {
    protected static Logger _logger = Logger.getLogger(ReportEngineClientJunitListener.class.getName());
    private static RemoteAPI reportEngineClientAPI = new RemoteAPI();

    public ReportEngineClientJunitListener() {
        try {
            reportEngineClientAPI.initClient(InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "]");
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "Report Engine Client Failed to start!!", ex);
        }
    }

    public void testRunStarted(Description description) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            reportEngineClientAPI.runLogHandler();
            try {
                if (description != null && description.getDisplayName() != null) {
                    reportEngineClientAPI.updateTestSuiteName(description.getDisplayName());
                    return;
                }
                reportEngineClientAPI.insertTestGroup("Junit - No groups");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testRunStarted,", ex);
            }
        }
    }

    public void testRunFinished(Result result) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngineClientAPI.updateTestSuite("Completed", reportEngineClientAPI.getBuildVersionReference());
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testRunFinished,", ex);
            }
        }
    }

    public void testStarted(Description description) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngineClientAPI.insertTestCase(description.getMethodName(), description.getClassName() + "." + description.getMethodName(), "Running");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testStarted,", ex);
            }
        }
    }

    public void testFinished(Description description) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngineClientAPI.updateTestCase("Passed");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testFinished,", ex);
            }
        }
    }

    public void testFailure(Failure failure) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngineClientAPI.takeScreenShot();
                reportEngineClientAPI.updateTestCase("Failed", ClientCommon.toString(failure.getException()));
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testFailure,", ex);
            }
        }
    }

    public void testIgnored(Description description) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                if (reportEngineClientAPI.isLastTestStateRunning()) {
                    reportEngineClientAPI.updateTestCase("Skipped");
                } else {
                    reportEngineClientAPI.insertTestCase(description.getMethodName(), description.getClassName() + "." + description.getMethodName(), "Skipped");
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on testIgnored,", ex);
            }
        }
    }
}

