/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.ClientCommon;
import com.redhat.reportengine.client.RemoteAPI;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.internal.IResultListener;

public class ReportEngineClientTestNGListener
implements IResultListener,
ISuiteListener {
    protected static Logger _logger = Logger.getLogger(ReportEngineClientTestNGListener.class.getName());
    private static RemoteAPI reportEngine = new RemoteAPI();

    public ReportEngineClientTestNGListener() {
        try {
            reportEngine.initClient(InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "]");
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "Report Engine Client Failed to start!!", ex);
        }
    }

    public String getParametersString(Object[] parameters) {
        String parametersString = "";
        if (parameters != null && parameters.length > 0) {
            parametersString = Arrays.deepToString(parameters);
        }
        return parametersString;
    }

    public void onFinish(ITestContext context) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            // empty if block
        }
    }

    public void onStart(ITestContext context) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngine.insertTestGroup(context.getName());
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onStart,", ex);
            }
        }
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult arg0) {
    }

    public void onTestFailure(ITestResult result) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngine.takeScreenShot();
                reportEngine.updateTestCase("Failed", ClientCommon.toString(result.getThrowable()));
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onTestFailure,", ex);
            }
        }
    }

    public void onTestSkipped(ITestResult result) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                if (reportEngine.isLastTestStateRunning()) {
                    reportEngine.updateTestCase("Skipped");
                } else {
                    reportEngine.insertTestCase(result.getName(), result.getName() + "(" + this.getParametersString(result.getParameters()) + ")", "Skipped");
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onTestSkipped,", ex);
            }
        }
    }

    public void onTestStart(ITestResult test) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngine.insertTestCase(test.getName(), test.getName() + "(" + this.getParametersString(test.getParameters()) + ")", "Running");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onTestStart,", ex);
            }
        }
    }

    public void onTestSuccess(ITestResult result) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngine.updateTestCase("Passed");
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onTestSuccess,", ex);
            }
        }
    }

    public void onConfigurationFailure(ITestResult testResult) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            if (testResult.getThrowable() == null) {
                _logger.log(Level.WARNING, "Configuration Failed!!");
            } else {
                _logger.log(Level.WARNING, "Configuration Failed!!", testResult.getThrowable());
            }
        }
    }

    public void onConfigurationSkip(ITestResult testResult) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            if (testResult.getThrowable() == null) {
                _logger.log(Level.WARNING, "Configuration Skipped!!");
            } else {
                _logger.log(Level.WARNING, "Configuration Skipped!!", testResult.getThrowable());
            }
        }
    }

    public void onConfigurationSuccess(ITestResult testResult) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            _logger.log(Level.FINE, "Configuration loadded Successfully!!");
        }
    }

    public void onFinish(ISuite suite) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngine.updateTestSuite("Completed", System.getProperty(reportEngine.getBuildVersionReference()));
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onFinish,", ex);
            }
        }
    }

    public void onStart(ISuite suite) {
        if (RemoteAPI.isClientLoadedSuccess()) {
            try {
                reportEngine.runLogHandler();
                reportEngine.updateTestSuiteName(suite.getName());
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "Error on onStart,", ex);
            }
        }
    }
}

