/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.ClientCommon;
import com.redhat.reportengine.client.RemoteAPI;
import com.redhat.reportengine.server.dbmap.TestLogs;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class JulReportEngineLogHandler
extends Handler {
    private RemoteAPI remoteApi;

    public JulReportEngineLogHandler(RemoteAPI remoteApi) {
        this.remoteApi = remoteApi;
    }

    public void publish(LogRecord record) {
        TestLogs testLogs = new TestLogs();
        testLogs.setLogLevel(record.getLevel().getName());
        testLogs.setLogTime(new Date(record.getMillis()));
        testLogs.setMessage(record.getMessage());
        testLogs.setSequenceNumber(Long.valueOf(record.getSequenceNumber()));
        testLogs.setClassName(record.getSourceClassName());
        testLogs.setMethodName(record.getSourceMethodName());
        testLogs.setThrowable(ClientCommon.toString(record.getThrown()));
        try {
            this.remoteApi.insertLogMessage(testLogs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void flush() {
        System.err.println("Report Engine Client: called JUL Flush...");
    }

    public void close() throws SecurityException {
        System.err.println("Report Engine Client: called JUL Close...");
    }
}

