/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.JulReportEngineLogHandler;
import com.redhat.reportengine.client.Log4jReportEngineLogHandler;
import com.redhat.reportengine.client.RemoteAPI;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LogHandler {
    protected static RemoteAPI remoteApi;
    protected static boolean isLoadedHandler;
    protected static JulReportEngineLogHandler reportEngineJulHandler;
    protected static Log4jReportEngineLogHandler reportEngineLog4jHandler;
    private static final java.util.logging.Logger _logger;
    public static final String LOG_LEVEL_DEFAULT = "DEFAULT";
    public static final String LOG_LEVEL_FINEST = "FINEST";
    public static final String LOG_LEVEL_FINER = "FINER";
    public static final String LOG_LEVEL_FINE = "FINE";
    public static final String LOG_LEVEL_WARNING = "WARNING";
    public static final String LOG_LEVEL_SEVERE = "SEVERE";
    public static final String LOGGER_JUL = "JUL";
    public static final String LOGGER_LOG4J = "LOG4J";

    private static String getLogLevel(String level) {
        if (level.equalsIgnoreCase(LOG_LEVEL_FINEST)) {
            return Level.TRACE.toString();
        }
        if (level.equalsIgnoreCase(LOG_LEVEL_FINER)) {
            return Level.TRACE.toString();
        }
        if (level.equalsIgnoreCase(LOG_LEVEL_FINE)) {
            return Level.DEBUG.toString();
        }
        if (level.equalsIgnoreCase(LOG_LEVEL_WARNING)) {
            return Level.WARN.toString();
        }
        if (level.equalsIgnoreCase(LOG_LEVEL_SEVERE)) {
            return Level.ERROR.toString();
        }
        return null;
    }

    public static void julLoggerSetup() {
        java.util.logging.Logger julLogger = java.util.logging.Logger.getLogger("");
        if (!remoteApi.getLogLevel().equalsIgnoreCase(LOG_LEVEL_DEFAULT)) {
            julLogger.setLevel(java.util.logging.Level.parse(remoteApi.getLogLevel()));
        }
        if (isLoadedHandler) {
            julLogger.removeHandler(reportEngineJulHandler);
            julLogger.addHandler(reportEngineJulHandler);
            remoteApi.setLoggers("org.apache.http,com.sun.xml.bind,com.sun.jersey,org.jboss.resteasy", java.util.logging.Level.WARNING);
            _logger.log(java.util.logging.Level.INFO, "Report Engine Client: JUL Handler reloaded...");
        } else {
            reportEngineJulHandler = new JulReportEngineLogHandler(LogHandler.getRemoteApi());
            julLogger.addHandler(reportEngineJulHandler);
            remoteApi.setLoggers("org.apache.http,com.sun.xml.bind,com.sun.jersey,org.jboss.resteasy", java.util.logging.Level.WARNING);
            _logger.log(java.util.logging.Level.INFO, "Report Engine Client: JUL Handler added...");
            isLoadedHandler = true;
        }
        _logger.log(java.util.logging.Level.INFO, "Report Engine Client: Log Level (JUL): " + julLogger.getLevel());
    }

    public static void log4jLoggerSetup() {
        Logger log4jLogger = Logger.getLogger((String)"");
        if (remoteApi.getLogLevel().equalsIgnoreCase(LOG_LEVEL_DEFAULT)) {
            log4jLogger.setLevel(Level.toLevel((String)LogHandler.getLogLevel(_logger.getLevel().toString()), (Level)Level.INFO));
        } else {
            log4jLogger.setLevel(Level.toLevel((String)remoteApi.getLogLevel(), (Level)Level.INFO));
        }
        if (isLoadedHandler) {
            log4jLogger.removeAppender((Appender)reportEngineLog4jHandler);
            log4jLogger.addAppender((Appender)reportEngineLog4jHandler);
            remoteApi.setLoggers("org.apache.http,com.sun.xml.bind,com.sun.jersey,org.jboss.resteasy", java.util.logging.Level.WARNING);
            _logger.log(java.util.logging.Level.INFO, "Report Engine Client: JUL Handler reloaded...");
        } else {
            reportEngineLog4jHandler = new Log4jReportEngineLogHandler(LogHandler.getRemoteApi());
            log4jLogger.addAppender((Appender)reportEngineLog4jHandler);
            remoteApi.setLoggers("org.apache.http,com.sun.xml.bind,com.sun.jersey,org.jboss.resteasy", java.util.logging.Level.WARNING);
            _logger.log(java.util.logging.Level.INFO, "Report Engine Client: JUL Handler added...");
            isLoadedHandler = true;
        }
        _logger.log(java.util.logging.Level.INFO, "Report Engine Client: Log Level (log4j): " + log4jLogger.getLevel());
    }

    public static RemoteAPI getRemoteApi() {
        return remoteApi;
    }

    public static void setRemoteApi(RemoteAPI remoteApi) {
        LogHandler.remoteApi = remoteApi;
    }

    public static void initLogger() {
        if (remoteApi.getLoggerType().equalsIgnoreCase(LOGGER_JUL)) {
            LogHandler.julLoggerSetup();
        } else if (remoteApi.getLoggerType().equalsIgnoreCase(LOGGER_LOG4J)) {
            LogHandler.log4jLoggerSetup();
        } else {
            _logger.log(java.util.logging.Level.WARNING, "Report Engine Client: Un-supported Logger Type: " + remoteApi.getLoggerType());
        }
    }

    static {
        isLoadedHandler = false;
        reportEngineJulHandler = null;
        reportEngineLog4jHandler = null;
        _logger = java.util.logging.Logger.getLogger(LogHandler.class.getName());
    }
}

