/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.reportengine.client;

import com.redhat.reportengine.client.ClientCommon;
import com.redhat.reportengine.client.RemoteAPI;
import com.redhat.reportengine.server.dbmap.TestLogs;
import java.util.Date;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jReportEngineLogHandler
extends AppenderSkeleton {
    private static long sequenceNumber;
    private RemoteAPI remoteApi;

    public Log4jReportEngineLogHandler(RemoteAPI remoteApi) {
        this.remoteApi = remoteApi;
    }

    public void close() throws SecurityException {
        System.err.println("Report Engine Client: called LOG4J Close...");
    }

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent record) {
        TestLogs testLogs = new TestLogs();
        testLogs.setLogLevel(record.getLevel().toString());
        testLogs.setLogTime(new Date(record.getTimeStamp()));
        testLogs.setMessage(record.getMessage().toString());
        testLogs.setSequenceNumber(Long.valueOf(Log4jReportEngineLogHandler.getSequenceNumber()));
        testLogs.setClassName(record.getLocationInformation().getClassName());
        testLogs.setMethodName(record.getLocationInformation().getMethodName() + ":" + record.getLocationInformation().getLineNumber());
        testLogs.setThrowable(ClientCommon.toString(record.getThrowableInformation().getThrowable()));
        try {
            this.remoteApi.insertLogMessage(testLogs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static long getSequenceNumber() {
        return sequenceNumber++;
    }
}

